package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{MulticastGroupId, FuotaTaskId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DisassociateMulticastGroupFromFuotaTaskRequest(
    id: FuotaTaskId,
    multicastGroupId: MulticastGroupId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.DisassociateMulticastGroupFromFuotaTaskRequest = {
    import DisassociateMulticastGroupFromFuotaTaskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.DisassociateMulticastGroupFromFuotaTaskRequest
      .builder()
      .id(FuotaTaskId.unwrap(id): java.lang.String)
      .multicastGroupId(
        MulticastGroupId.unwrap(multicastGroupId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.DisassociateMulticastGroupFromFuotaTaskRequest.ReadOnly =
    zio.aws.iotwireless.model.DisassociateMulticastGroupFromFuotaTaskRequest
      .wrap(buildAwsValue())
}
object DisassociateMulticastGroupFromFuotaTaskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.DisassociateMulticastGroupFromFuotaTaskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotwireless.model.DisassociateMulticastGroupFromFuotaTaskRequest =
      zio.aws.iotwireless.model
        .DisassociateMulticastGroupFromFuotaTaskRequest(id, multicastGroupId)
    def id: FuotaTaskId
    def multicastGroupId: MulticastGroupId
    def getId: ZIO[Any, Nothing, FuotaTaskId] = ZIO.succeed(id)
    def getMulticastGroupId: ZIO[Any, Nothing, MulticastGroupId] =
      ZIO.succeed(multicastGroupId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.DisassociateMulticastGroupFromFuotaTaskRequest
  ) extends zio.aws.iotwireless.model.DisassociateMulticastGroupFromFuotaTaskRequest.ReadOnly {
    override val id: FuotaTaskId =
      zio.aws.iotwireless.model.primitives.FuotaTaskId(impl.id())
    override val multicastGroupId: MulticastGroupId =
      zio.aws.iotwireless.model.primitives
        .MulticastGroupId(impl.multicastGroupId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.DisassociateMulticastGroupFromFuotaTaskRequest
  ): zio.aws.iotwireless.model.DisassociateMulticastGroupFromFuotaTaskRequest.ReadOnly =
    new Wrapper(impl)
}
