package zio.aws.iotwireless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeviceRegistrationStateResourceTypeEventConfiguration(
    sidewalk: Optional[
      zio.aws.iotwireless.model.SidewalkResourceTypeEventConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.DeviceRegistrationStateResourceTypeEventConfiguration = {
    import DeviceRegistrationStateResourceTypeEventConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.DeviceRegistrationStateResourceTypeEventConfiguration
      .builder()
      .optionallyWith(sidewalk.map(value => value.buildAwsValue()))(_.sidewalk)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.DeviceRegistrationStateResourceTypeEventConfiguration.ReadOnly =
    zio.aws.iotwireless.model.DeviceRegistrationStateResourceTypeEventConfiguration
      .wrap(buildAwsValue())
}
object DeviceRegistrationStateResourceTypeEventConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.DeviceRegistrationStateResourceTypeEventConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotwireless.model.DeviceRegistrationStateResourceTypeEventConfiguration =
      zio.aws.iotwireless.model
        .DeviceRegistrationStateResourceTypeEventConfiguration(
          sidewalk.map(value => value.asEditable)
        )
    def sidewalk: Optional[
      zio.aws.iotwireless.model.SidewalkResourceTypeEventConfiguration.ReadOnly
    ]
    def getSidewalk: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.SidewalkResourceTypeEventConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("sidewalk", sidewalk)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.DeviceRegistrationStateResourceTypeEventConfiguration
  ) extends zio.aws.iotwireless.model.DeviceRegistrationStateResourceTypeEventConfiguration.ReadOnly {
    override val sidewalk: Optional[
      zio.aws.iotwireless.model.SidewalkResourceTypeEventConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sidewalk())
      .map(value =>
        zio.aws.iotwireless.model.SidewalkResourceTypeEventConfiguration
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.DeviceRegistrationStateResourceTypeEventConfiguration
  ): zio.aws.iotwireless.model.DeviceRegistrationStateResourceTypeEventConfiguration.ReadOnly =
    new Wrapper(impl)
}
