package zio.aws.iotwireless.model
import scala.jdk.CollectionConverters._
sealed trait DeviceProfileType {
  def unwrap
      : software.amazon.awssdk.services.iotwireless.model.DeviceProfileType
}
object DeviceProfileType {
  def wrap(
      value: software.amazon.awssdk.services.iotwireless.model.DeviceProfileType
  ): zio.aws.iotwireless.model.DeviceProfileType = value match {
    case software.amazon.awssdk.services.iotwireless.model.DeviceProfileType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotwireless.model.DeviceProfileType.SIDEWALK =>
      val r = Sidewalk
      r
    case software.amazon.awssdk.services.iotwireless.model.DeviceProfileType.LO_RA_WAN =>
      val r = LoRaWAN
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iotwireless.model.DeviceProfileType {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.DeviceProfileType =
      software.amazon.awssdk.services.iotwireless.model.DeviceProfileType.UNKNOWN_TO_SDK_VERSION
  }
  case object Sidewalk extends zio.aws.iotwireless.model.DeviceProfileType {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.DeviceProfileType =
      software.amazon.awssdk.services.iotwireless.model.DeviceProfileType.SIDEWALK
  }
  case object LoRaWAN extends zio.aws.iotwireless.model.DeviceProfileType {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.DeviceProfileType =
      software.amazon.awssdk.services.iotwireless.model.DeviceProfileType.LO_RA_WAN
  }
}
