package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.Identifier
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeregisterWirelessDeviceRequest(
    identifier: Identifier,
    wirelessDeviceType: Optional[zio.aws.iotwireless.model.WirelessDeviceType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.DeregisterWirelessDeviceRequest = {
    import DeregisterWirelessDeviceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.DeregisterWirelessDeviceRequest
      .builder()
      .identifier(Identifier.unwrap(identifier): java.lang.String)
      .optionallyWith(wirelessDeviceType.map(value => value.unwrap))(
        _.wirelessDeviceType
      )
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.DeregisterWirelessDeviceRequest.ReadOnly =
    zio.aws.iotwireless.model.DeregisterWirelessDeviceRequest
      .wrap(buildAwsValue())
}
object DeregisterWirelessDeviceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.DeregisterWirelessDeviceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.DeregisterWirelessDeviceRequest =
      zio.aws.iotwireless.model.DeregisterWirelessDeviceRequest(
        identifier,
        wirelessDeviceType.map(value => value)
      )
    def identifier: Identifier
    def wirelessDeviceType
        : Optional[zio.aws.iotwireless.model.WirelessDeviceType]
    def getIdentifier: ZIO[Any, Nothing, Identifier] = ZIO.succeed(identifier)
    def getWirelessDeviceType
        : ZIO[Any, AwsError, zio.aws.iotwireless.model.WirelessDeviceType] =
      AwsError.unwrapOptionField("wirelessDeviceType", wirelessDeviceType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.DeregisterWirelessDeviceRequest
  ) extends zio.aws.iotwireless.model.DeregisterWirelessDeviceRequest.ReadOnly {
    override val identifier: Identifier =
      zio.aws.iotwireless.model.primitives.Identifier(impl.identifier())
    override val wirelessDeviceType
        : Optional[zio.aws.iotwireless.model.WirelessDeviceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.wirelessDeviceType())
        .map(value => zio.aws.iotwireless.model.WirelessDeviceType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.DeregisterWirelessDeviceRequest
  ): zio.aws.iotwireless.model.DeregisterWirelessDeviceRequest.ReadOnly =
    new Wrapper(impl)
}
