package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.WirelessDeviceId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteWirelessDeviceRequest(id: WirelessDeviceId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.DeleteWirelessDeviceRequest = {
    import DeleteWirelessDeviceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.DeleteWirelessDeviceRequest
      .builder()
      .id(WirelessDeviceId.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.DeleteWirelessDeviceRequest.ReadOnly =
    zio.aws.iotwireless.model.DeleteWirelessDeviceRequest.wrap(buildAwsValue())
}
object DeleteWirelessDeviceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.DeleteWirelessDeviceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.DeleteWirelessDeviceRequest =
      zio.aws.iotwireless.model.DeleteWirelessDeviceRequest(id)
    def id: WirelessDeviceId
    def getId: ZIO[Any, Nothing, WirelessDeviceId] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.DeleteWirelessDeviceRequest
  ) extends zio.aws.iotwireless.model.DeleteWirelessDeviceRequest.ReadOnly {
    override val id: WirelessDeviceId =
      zio.aws.iotwireless.model.primitives.WirelessDeviceId(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.DeleteWirelessDeviceRequest
  ): zio.aws.iotwireless.model.DeleteWirelessDeviceRequest.ReadOnly =
    new Wrapper(impl)
}
