package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.ImportTaskId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteWirelessDeviceImportTaskRequest(id: ImportTaskId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.DeleteWirelessDeviceImportTaskRequest = {
    import DeleteWirelessDeviceImportTaskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.DeleteWirelessDeviceImportTaskRequest
      .builder()
      .id(ImportTaskId.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.DeleteWirelessDeviceImportTaskRequest.ReadOnly =
    zio.aws.iotwireless.model.DeleteWirelessDeviceImportTaskRequest
      .wrap(buildAwsValue())
}
object DeleteWirelessDeviceImportTaskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.DeleteWirelessDeviceImportTaskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotwireless.model.DeleteWirelessDeviceImportTaskRequest =
      zio.aws.iotwireless.model.DeleteWirelessDeviceImportTaskRequest(id)
    def id: ImportTaskId
    def getId: ZIO[Any, Nothing, ImportTaskId] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.DeleteWirelessDeviceImportTaskRequest
  ) extends zio.aws.iotwireless.model.DeleteWirelessDeviceImportTaskRequest.ReadOnly {
    override val id: ImportTaskId =
      zio.aws.iotwireless.model.primitives.ImportTaskId(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.DeleteWirelessDeviceImportTaskRequest
  ): zio.aws.iotwireless.model.DeleteWirelessDeviceImportTaskRequest.ReadOnly =
    new Wrapper(impl)
}
