package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.NetworkAnalyzerConfigurationName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteNetworkAnalyzerConfigurationRequest(
    configurationName: NetworkAnalyzerConfigurationName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.DeleteNetworkAnalyzerConfigurationRequest = {
    import DeleteNetworkAnalyzerConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.DeleteNetworkAnalyzerConfigurationRequest
      .builder()
      .configurationName(
        NetworkAnalyzerConfigurationName.unwrap(
          configurationName
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.DeleteNetworkAnalyzerConfigurationRequest.ReadOnly =
    zio.aws.iotwireless.model.DeleteNetworkAnalyzerConfigurationRequest
      .wrap(buildAwsValue())
}
object DeleteNetworkAnalyzerConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.DeleteNetworkAnalyzerConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotwireless.model.DeleteNetworkAnalyzerConfigurationRequest =
      zio.aws.iotwireless.model
        .DeleteNetworkAnalyzerConfigurationRequest(configurationName)
    def configurationName: NetworkAnalyzerConfigurationName
    def getConfigurationName
        : ZIO[Any, Nothing, NetworkAnalyzerConfigurationName] =
      ZIO.succeed(configurationName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.DeleteNetworkAnalyzerConfigurationRequest
  ) extends zio.aws.iotwireless.model.DeleteNetworkAnalyzerConfigurationRequest.ReadOnly {
    override val configurationName: NetworkAnalyzerConfigurationName =
      zio.aws.iotwireless.model.primitives
        .NetworkAnalyzerConfigurationName(impl.configurationName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.DeleteNetworkAnalyzerConfigurationRequest
  ): zio.aws.iotwireless.model.DeleteNetworkAnalyzerConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
