package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{
  ClientRequestToken,
  DestinationName,
  Description,
  WirelessDeviceName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateWirelessDeviceRequest(
    `type`: zio.aws.iotwireless.model.WirelessDeviceType,
    name: Optional[WirelessDeviceName] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    destinationName: DestinationName,
    clientRequestToken: Optional[ClientRequestToken] = Optional.Absent,
    loRaWAN: Optional[zio.aws.iotwireless.model.LoRaWANDevice] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.iotwireless.model.Tag]] = Optional.Absent,
    positioning: Optional[zio.aws.iotwireless.model.PositioningConfigStatus] =
      Optional.Absent,
    sidewalk: Optional[zio.aws.iotwireless.model.SidewalkCreateWirelessDevice] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.CreateWirelessDeviceRequest = {
    import CreateWirelessDeviceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.CreateWirelessDeviceRequest
      .builder()
      .`type`(`type`.unwrap)
      .optionallyWith(
        name.map(value => WirelessDeviceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .destinationName(
        DestinationName.unwrap(destinationName): java.lang.String
      )
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .optionallyWith(loRaWAN.map(value => value.buildAwsValue()))(_.loRaWAN)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(positioning.map(value => value.unwrap))(_.positioning)
      .optionallyWith(sidewalk.map(value => value.buildAwsValue()))(_.sidewalk)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.CreateWirelessDeviceRequest.ReadOnly =
    zio.aws.iotwireless.model.CreateWirelessDeviceRequest.wrap(buildAwsValue())
}
object CreateWirelessDeviceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.CreateWirelessDeviceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.CreateWirelessDeviceRequest =
      zio.aws.iotwireless.model.CreateWirelessDeviceRequest(
        `type`,
        name.map(value => value),
        description.map(value => value),
        destinationName,
        clientRequestToken.map(value => value),
        loRaWAN.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        positioning.map(value => value),
        sidewalk.map(value => value.asEditable)
      )
    def `type`: zio.aws.iotwireless.model.WirelessDeviceType
    def name: Optional[WirelessDeviceName]
    def description: Optional[Description]
    def destinationName: DestinationName
    def clientRequestToken: Optional[ClientRequestToken]
    def loRaWAN: Optional[zio.aws.iotwireless.model.LoRaWANDevice.ReadOnly]
    def tags: Optional[List[zio.aws.iotwireless.model.Tag.ReadOnly]]
    def positioning: Optional[zio.aws.iotwireless.model.PositioningConfigStatus]
    def sidewalk: Optional[
      zio.aws.iotwireless.model.SidewalkCreateWirelessDevice.ReadOnly
    ]
    def getType
        : ZIO[Any, Nothing, zio.aws.iotwireless.model.WirelessDeviceType] =
      ZIO.succeed(`type`)
    def getName: ZIO[Any, AwsError, WirelessDeviceName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getDestinationName: ZIO[Any, Nothing, DestinationName] =
      ZIO.succeed(destinationName)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getLoRaWAN
        : ZIO[Any, AwsError, zio.aws.iotwireless.model.LoRaWANDevice.ReadOnly] =
      AwsError.unwrapOptionField("loRaWAN", loRaWAN)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.iotwireless.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getPositioning: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.PositioningConfigStatus
    ] = AwsError.unwrapOptionField("positioning", positioning)
    def getSidewalk: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.SidewalkCreateWirelessDevice.ReadOnly
    ] = AwsError.unwrapOptionField("sidewalk", sidewalk)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.CreateWirelessDeviceRequest
  ) extends zio.aws.iotwireless.model.CreateWirelessDeviceRequest.ReadOnly {
    override val `type`: zio.aws.iotwireless.model.WirelessDeviceType =
      zio.aws.iotwireless.model.WirelessDeviceType.wrap(impl.`type`())
    override val name: Optional[WirelessDeviceName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.iotwireless.model.primitives.WirelessDeviceName(value)
      )
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.iotwireless.model.primitives.Description(value))
    override val destinationName: DestinationName =
      zio.aws.iotwireless.model.primitives
        .DestinationName(impl.destinationName())
    override val clientRequestToken: Optional[ClientRequestToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value =>
          zio.aws.iotwireless.model.primitives.ClientRequestToken(value)
        )
    override val loRaWAN
        : Optional[zio.aws.iotwireless.model.LoRaWANDevice.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.loRaWAN())
        .map(value => zio.aws.iotwireless.model.LoRaWANDevice.wrap(value))
    override val tags: Optional[List[zio.aws.iotwireless.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotwireless.model.Tag.wrap(item)
          }.toList
        )
    override val positioning
        : Optional[zio.aws.iotwireless.model.PositioningConfigStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.positioning())
        .map(value =>
          zio.aws.iotwireless.model.PositioningConfigStatus.wrap(value)
        )
    override val sidewalk: Optional[
      zio.aws.iotwireless.model.SidewalkCreateWirelessDevice.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sidewalk())
      .map(value =>
        zio.aws.iotwireless.model.SidewalkCreateWirelessDevice.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.CreateWirelessDeviceRequest
  ): zio.aws.iotwireless.model.CreateWirelessDeviceRequest.ReadOnly =
    new Wrapper(impl)
}
