package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{DeviceProfileId, DeviceProfileArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateDeviceProfileResponse(
    arn: Optional[DeviceProfileArn] = Optional.Absent,
    id: Optional[DeviceProfileId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.CreateDeviceProfileResponse = {
    import CreateDeviceProfileResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.CreateDeviceProfileResponse
      .builder()
      .optionallyWith(
        arn.map(value => DeviceProfileArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        id.map(value => DeviceProfileId.unwrap(value): java.lang.String)
      )(_.id)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.CreateDeviceProfileResponse.ReadOnly =
    zio.aws.iotwireless.model.CreateDeviceProfileResponse.wrap(buildAwsValue())
}
object CreateDeviceProfileResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.CreateDeviceProfileResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.CreateDeviceProfileResponse =
      zio.aws.iotwireless.model.CreateDeviceProfileResponse(
        arn.map(value => value),
        id.map(value => value)
      )
    def arn: Optional[DeviceProfileArn]
    def id: Optional[DeviceProfileId]
    def getArn: ZIO[Any, AwsError, DeviceProfileArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getId: ZIO[Any, AwsError, DeviceProfileId] =
      AwsError.unwrapOptionField("id", id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.CreateDeviceProfileResponse
  ) extends zio.aws.iotwireless.model.CreateDeviceProfileResponse.ReadOnly {
    override val arn: Optional[DeviceProfileArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value =>
        zio.aws.iotwireless.model.primitives.DeviceProfileArn(value)
      )
    override val id: Optional[DeviceProfileId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.iotwireless.model.primitives.DeviceProfileId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.CreateDeviceProfileResponse
  ): zio.aws.iotwireless.model.CreateDeviceProfileResponse.ReadOnly =
    new Wrapper(impl)
}
