package zio.aws.iotwireless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CellTowers(
    gsm: Optional[Iterable[zio.aws.iotwireless.model.GsmObj]] = Optional.Absent,
    wcdma: Optional[Iterable[zio.aws.iotwireless.model.WcdmaObj]] =
      Optional.Absent,
    tdscdma: Optional[Iterable[zio.aws.iotwireless.model.TdscdmaObj]] =
      Optional.Absent,
    lte: Optional[Iterable[zio.aws.iotwireless.model.LteObj]] = Optional.Absent,
    cdma: Optional[Iterable[zio.aws.iotwireless.model.CdmaObj]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.CellTowers = {
    import CellTowers.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.CellTowers
      .builder()
      .optionallyWith(
        gsm.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.gsm)
      .optionallyWith(
        wcdma.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.wcdma)
      .optionallyWith(
        tdscdma.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tdscdma)
      .optionallyWith(
        lte.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.lte)
      .optionallyWith(
        cdma.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.cdma)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.CellTowers.ReadOnly =
    zio.aws.iotwireless.model.CellTowers.wrap(buildAwsValue())
}
object CellTowers {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.CellTowers
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.CellTowers =
      zio.aws.iotwireless.model.CellTowers(
        gsm.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        wcdma.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tdscdma.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        lte.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        cdma.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def gsm: Optional[List[zio.aws.iotwireless.model.GsmObj.ReadOnly]]
    def wcdma: Optional[List[zio.aws.iotwireless.model.WcdmaObj.ReadOnly]]
    def tdscdma: Optional[List[zio.aws.iotwireless.model.TdscdmaObj.ReadOnly]]
    def lte: Optional[List[zio.aws.iotwireless.model.LteObj.ReadOnly]]
    def cdma: Optional[List[zio.aws.iotwireless.model.CdmaObj.ReadOnly]]
    def getGsm
        : ZIO[Any, AwsError, List[zio.aws.iotwireless.model.GsmObj.ReadOnly]] =
      AwsError.unwrapOptionField("gsm", gsm)
    def getWcdma: ZIO[Any, AwsError, List[
      zio.aws.iotwireless.model.WcdmaObj.ReadOnly
    ]] = AwsError.unwrapOptionField("wcdma", wcdma)
    def getTdscdma: ZIO[Any, AwsError, List[
      zio.aws.iotwireless.model.TdscdmaObj.ReadOnly
    ]] = AwsError.unwrapOptionField("tdscdma", tdscdma)
    def getLte
        : ZIO[Any, AwsError, List[zio.aws.iotwireless.model.LteObj.ReadOnly]] =
      AwsError.unwrapOptionField("lte", lte)
    def getCdma
        : ZIO[Any, AwsError, List[zio.aws.iotwireless.model.CdmaObj.ReadOnly]] =
      AwsError.unwrapOptionField("cdma", cdma)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.CellTowers
  ) extends zio.aws.iotwireless.model.CellTowers.ReadOnly {
    override val gsm
        : Optional[List[zio.aws.iotwireless.model.GsmObj.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.gsm())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotwireless.model.GsmObj.wrap(item)
          }.toList
        )
    override val wcdma
        : Optional[List[zio.aws.iotwireless.model.WcdmaObj.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.wcdma())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotwireless.model.WcdmaObj.wrap(item)
          }.toList
        )
    override val tdscdma
        : Optional[List[zio.aws.iotwireless.model.TdscdmaObj.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tdscdma())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotwireless.model.TdscdmaObj.wrap(item)
          }.toList
        )
    override val lte
        : Optional[List[zio.aws.iotwireless.model.LteObj.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lte())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotwireless.model.LteObj.wrap(item)
          }.toList
        )
    override val cdma
        : Optional[List[zio.aws.iotwireless.model.CdmaObj.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cdma())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotwireless.model.CdmaObj.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.CellTowers
  ): zio.aws.iotwireless.model.CellTowers.ReadOnly = new Wrapper(impl)
}
