package zio.aws.iotwireless.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iotwireless.model.primitives.{
  NetworkId,
  BaseStationId,
  BaseLng,
  BaseLat,
  RegistrationZone,
  PilotPower,
  SystemId
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class CdmaObj(
    systemId: SystemId,
    networkId: NetworkId,
    baseStationId: BaseStationId,
    registrationZone: Optional[RegistrationZone] = Optional.Absent,
    cdmaLocalId: Optional[zio.aws.iotwireless.model.CdmaLocalId] =
      Optional.Absent,
    pilotPower: Optional[PilotPower] = Optional.Absent,
    baseLat: Optional[BaseLat] = Optional.Absent,
    baseLng: Optional[BaseLng] = Optional.Absent,
    cdmaNmr: Optional[Iterable[zio.aws.iotwireless.model.CdmaNmrObj]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.CdmaObj = {
    import CdmaObj.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.CdmaObj
      .builder()
      .systemId(SystemId.unwrap(systemId): Integer)
      .networkId(NetworkId.unwrap(networkId): Integer)
      .baseStationId(BaseStationId.unwrap(baseStationId): Integer)
      .optionallyWith(
        registrationZone.map(value => RegistrationZone.unwrap(value): Integer)
      )(_.registrationZone)
      .optionallyWith(cdmaLocalId.map(value => value.buildAwsValue()))(
        _.cdmaLocalId
      )
      .optionallyWith(
        pilotPower.map(value => PilotPower.unwrap(value): Integer)
      )(_.pilotPower)
      .optionallyWith(
        baseLat.map(value => BaseLat.unwrap(value): java.lang.Float)
      )(_.baseLat)
      .optionallyWith(
        baseLng.map(value => BaseLng.unwrap(value): java.lang.Float)
      )(_.baseLng)
      .optionallyWith(
        cdmaNmr.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.cdmaNmr)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.CdmaObj.ReadOnly =
    zio.aws.iotwireless.model.CdmaObj.wrap(buildAwsValue())
}
object CdmaObj {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.CdmaObj
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.CdmaObj =
      zio.aws.iotwireless.model.CdmaObj(
        systemId,
        networkId,
        baseStationId,
        registrationZone.map(value => value),
        cdmaLocalId.map(value => value.asEditable),
        pilotPower.map(value => value),
        baseLat.map(value => value),
        baseLng.map(value => value),
        cdmaNmr.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def systemId: SystemId
    def networkId: NetworkId
    def baseStationId: BaseStationId
    def registrationZone: Optional[RegistrationZone]
    def cdmaLocalId: Optional[zio.aws.iotwireless.model.CdmaLocalId.ReadOnly]
    def pilotPower: Optional[PilotPower]
    def baseLat: Optional[BaseLat]
    def baseLng: Optional[BaseLng]
    def cdmaNmr: Optional[List[zio.aws.iotwireless.model.CdmaNmrObj.ReadOnly]]
    def getSystemId: ZIO[Any, Nothing, SystemId] = ZIO.succeed(systemId)
    def getNetworkId: ZIO[Any, Nothing, NetworkId] = ZIO.succeed(networkId)
    def getBaseStationId: ZIO[Any, Nothing, BaseStationId] =
      ZIO.succeed(baseStationId)
    def getRegistrationZone: ZIO[Any, AwsError, RegistrationZone] =
      AwsError.unwrapOptionField("registrationZone", registrationZone)
    def getCdmaLocalId
        : ZIO[Any, AwsError, zio.aws.iotwireless.model.CdmaLocalId.ReadOnly] =
      AwsError.unwrapOptionField("cdmaLocalId", cdmaLocalId)
    def getPilotPower: ZIO[Any, AwsError, PilotPower] =
      AwsError.unwrapOptionField("pilotPower", pilotPower)
    def getBaseLat: ZIO[Any, AwsError, BaseLat] =
      AwsError.unwrapOptionField("baseLat", baseLat)
    def getBaseLng: ZIO[Any, AwsError, BaseLng] =
      AwsError.unwrapOptionField("baseLng", baseLng)
    def getCdmaNmr: ZIO[Any, AwsError, List[
      zio.aws.iotwireless.model.CdmaNmrObj.ReadOnly
    ]] = AwsError.unwrapOptionField("cdmaNmr", cdmaNmr)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.CdmaObj
  ) extends zio.aws.iotwireless.model.CdmaObj.ReadOnly {
    override val systemId: SystemId =
      zio.aws.iotwireless.model.primitives.SystemId(impl.systemId())
    override val networkId: NetworkId =
      zio.aws.iotwireless.model.primitives.NetworkId(impl.networkId())
    override val baseStationId: BaseStationId =
      zio.aws.iotwireless.model.primitives.BaseStationId(impl.baseStationId())
    override val registrationZone: Optional[RegistrationZone] =
      zio.aws.core.internal
        .optionalFromNullable(impl.registrationZone())
        .map(value =>
          zio.aws.iotwireless.model.primitives.RegistrationZone(value)
        )
    override val cdmaLocalId
        : Optional[zio.aws.iotwireless.model.CdmaLocalId.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cdmaLocalId())
        .map(value => zio.aws.iotwireless.model.CdmaLocalId.wrap(value))
    override val pilotPower: Optional[PilotPower] = zio.aws.core.internal
      .optionalFromNullable(impl.pilotPower())
      .map(value => zio.aws.iotwireless.model.primitives.PilotPower(value))
    override val baseLat: Optional[BaseLat] = zio.aws.core.internal
      .optionalFromNullable(impl.baseLat())
      .map(value => zio.aws.iotwireless.model.primitives.BaseLat(value))
    override val baseLng: Optional[BaseLng] = zio.aws.core.internal
      .optionalFromNullable(impl.baseLng())
      .map(value => zio.aws.iotwireless.model.primitives.BaseLng(value))
    override val cdmaNmr
        : Optional[List[zio.aws.iotwireless.model.CdmaNmrObj.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cdmaNmr())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotwireless.model.CdmaNmrObj.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.CdmaObj
  ): zio.aws.iotwireless.model.CdmaObj.ReadOnly = new Wrapper(impl)
}
