package zio.aws.iotwireless.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iotwireless.model.primitives.{
  BeaconingFrequency,
  BeaconingDataRate
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class Beaconing(
    dataRate: Optional[BeaconingDataRate] = Optional.Absent,
    frequencies: Optional[Iterable[BeaconingFrequency]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.Beaconing = {
    import Beaconing.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.Beaconing
      .builder()
      .optionallyWith(
        dataRate.map(value => BeaconingDataRate.unwrap(value): Integer)
      )(_.dataRate)
      .optionallyWith(
        frequencies.map(value =>
          value.map { item =>
            BeaconingFrequency.unwrap(item): Integer
          }.asJavaCollection
        )
      )(_.frequencies)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.Beaconing.ReadOnly =
    zio.aws.iotwireless.model.Beaconing.wrap(buildAwsValue())
}
object Beaconing {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.Beaconing
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.Beaconing =
      zio.aws.iotwireless.model.Beaconing(
        dataRate.map(value => value),
        frequencies.map(value => value)
      )
    def dataRate: Optional[BeaconingDataRate]
    def frequencies: Optional[List[BeaconingFrequency]]
    def getDataRate: ZIO[Any, AwsError, BeaconingDataRate] =
      AwsError.unwrapOptionField("dataRate", dataRate)
    def getFrequencies: ZIO[Any, AwsError, List[BeaconingFrequency]] =
      AwsError.unwrapOptionField("frequencies", frequencies)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.Beaconing
  ) extends zio.aws.iotwireless.model.Beaconing.ReadOnly {
    override val dataRate: Optional[BeaconingDataRate] = zio.aws.core.internal
      .optionalFromNullable(impl.dataRate())
      .map(value =>
        zio.aws.iotwireless.model.primitives.BeaconingDataRate(value)
      )
    override val frequencies: Optional[List[BeaconingFrequency]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.frequencies())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotwireless.model.primitives.BeaconingFrequency(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.Beaconing
  ): zio.aws.iotwireless.model.Beaconing.ReadOnly = new Wrapper(impl)
}
