package zio.aws.iotwireless.model
import scala.jdk.CollectionConverters._
sealed trait ApplicationConfigType {
  def unwrap
      : software.amazon.awssdk.services.iotwireless.model.ApplicationConfigType
}
object ApplicationConfigType {
  def wrap(
      value: software.amazon.awssdk.services.iotwireless.model.ApplicationConfigType
  ): zio.aws.iotwireless.model.ApplicationConfigType = value match {
    case software.amazon.awssdk.services.iotwireless.model.ApplicationConfigType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotwireless.model.ApplicationConfigType.SEMTECH_GEOLOCATION =>
      val r = SemtechGeolocation
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iotwireless.model.ApplicationConfigType {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.ApplicationConfigType =
      software.amazon.awssdk.services.iotwireless.model.ApplicationConfigType.UNKNOWN_TO_SDK_VERSION
  }
  case object SemtechGeolocation
      extends zio.aws.iotwireless.model.ApplicationConfigType {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.ApplicationConfigType =
      software.amazon.awssdk.services.iotwireless.model.ApplicationConfigType.SEMTECH_GEOLOCATION
  }
}
