package zio.aws.iotwireless.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iotwireless.model.primitives.{DestinationName, FPort}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ApplicationConfig(
    fPort: Optional[FPort] = Optional.Absent,
    `type`: Optional[zio.aws.iotwireless.model.ApplicationConfigType] =
      Optional.Absent,
    destinationName: Optional[DestinationName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.ApplicationConfig = {
    import ApplicationConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.ApplicationConfig
      .builder()
      .optionallyWith(fPort.map(value => FPort.unwrap(value): Integer))(_.fPort)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        destinationName.map(value =>
          DestinationName.unwrap(value): java.lang.String
        )
      )(_.destinationName)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.ApplicationConfig.ReadOnly =
    zio.aws.iotwireless.model.ApplicationConfig.wrap(buildAwsValue())
}
object ApplicationConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.ApplicationConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.ApplicationConfig =
      zio.aws.iotwireless.model.ApplicationConfig(
        fPort.map(value => value),
        `type`.map(value => value),
        destinationName.map(value => value)
      )
    def fPort: Optional[FPort]
    def `type`: Optional[zio.aws.iotwireless.model.ApplicationConfigType]
    def destinationName: Optional[DestinationName]
    def getFPort: ZIO[Any, AwsError, FPort] =
      AwsError.unwrapOptionField("fPort", fPort)
    def getType
        : ZIO[Any, AwsError, zio.aws.iotwireless.model.ApplicationConfigType] =
      AwsError.unwrapOptionField("type", `type`)
    def getDestinationName: ZIO[Any, AwsError, DestinationName] =
      AwsError.unwrapOptionField("destinationName", destinationName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.ApplicationConfig
  ) extends zio.aws.iotwireless.model.ApplicationConfig.ReadOnly {
    override val fPort: Optional[FPort] = zio.aws.core.internal
      .optionalFromNullable(impl.fPort())
      .map(value => zio.aws.iotwireless.model.primitives.FPort(value))
    override val `type`
        : Optional[zio.aws.iotwireless.model.ApplicationConfigType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value =>
          zio.aws.iotwireless.model.ApplicationConfigType.wrap(value)
        )
    override val destinationName: Optional[DestinationName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationName())
        .map(value =>
          zio.aws.iotwireless.model.primitives.DestinationName(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.ApplicationConfig
  ): zio.aws.iotwireless.model.ApplicationConfig.ReadOnly = new Wrapper(impl)
}
