package zio.aws.iotwireless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateFPorts(
    positioning: Optional[zio.aws.iotwireless.model.Positioning] =
      Optional.Absent,
    applications: Optional[
      Iterable[zio.aws.iotwireless.model.ApplicationConfig]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.UpdateFPorts = {
    import UpdateFPorts.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.UpdateFPorts
      .builder()
      .optionallyWith(positioning.map(value => value.buildAwsValue()))(
        _.positioning
      )
      .optionallyWith(
        applications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.applications)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.UpdateFPorts.ReadOnly =
    zio.aws.iotwireless.model.UpdateFPorts.wrap(buildAwsValue())
}
object UpdateFPorts {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.UpdateFPorts
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.UpdateFPorts =
      zio.aws.iotwireless.model.UpdateFPorts(
        positioning.map(value => value.asEditable),
        applications.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def positioning: Optional[zio.aws.iotwireless.model.Positioning.ReadOnly]
    def applications
        : Optional[List[zio.aws.iotwireless.model.ApplicationConfig.ReadOnly]]
    def getPositioning
        : ZIO[Any, AwsError, zio.aws.iotwireless.model.Positioning.ReadOnly] =
      AwsError.unwrapOptionField("positioning", positioning)
    def getApplications: ZIO[Any, AwsError, List[
      zio.aws.iotwireless.model.ApplicationConfig.ReadOnly
    ]] = AwsError.unwrapOptionField("applications", applications)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.UpdateFPorts
  ) extends zio.aws.iotwireless.model.UpdateFPorts.ReadOnly {
    override val positioning
        : Optional[zio.aws.iotwireless.model.Positioning.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.positioning())
        .map(value => zio.aws.iotwireless.model.Positioning.wrap(value))
    override val applications
        : Optional[List[zio.aws.iotwireless.model.ApplicationConfig.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.applications())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotwireless.model.ApplicationConfig.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.UpdateFPorts
  ): zio.aws.iotwireless.model.UpdateFPorts.ReadOnly = new Wrapper(impl)
}
