package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{Role, DeviceCreationFile}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SidewalkStartImportInfo(
    deviceCreationFile: Optional[DeviceCreationFile] = Optional.Absent,
    role: Optional[Role] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.SidewalkStartImportInfo = {
    import SidewalkStartImportInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.SidewalkStartImportInfo
      .builder()
      .optionallyWith(
        deviceCreationFile.map(value =>
          DeviceCreationFile.unwrap(value): java.lang.String
        )
      )(_.deviceCreationFile)
      .optionallyWith(role.map(value => Role.unwrap(value): java.lang.String))(
        _.role
      )
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.SidewalkStartImportInfo.ReadOnly =
    zio.aws.iotwireless.model.SidewalkStartImportInfo.wrap(buildAwsValue())
}
object SidewalkStartImportInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.SidewalkStartImportInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.SidewalkStartImportInfo =
      zio.aws.iotwireless.model.SidewalkStartImportInfo(
        deviceCreationFile.map(value => value),
        role.map(value => value)
      )
    def deviceCreationFile: Optional[DeviceCreationFile]
    def role: Optional[Role]
    def getDeviceCreationFile: ZIO[Any, AwsError, DeviceCreationFile] =
      AwsError.unwrapOptionField("deviceCreationFile", deviceCreationFile)
    def getRole: ZIO[Any, AwsError, Role] =
      AwsError.unwrapOptionField("role", role)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.SidewalkStartImportInfo
  ) extends zio.aws.iotwireless.model.SidewalkStartImportInfo.ReadOnly {
    override val deviceCreationFile: Optional[DeviceCreationFile] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deviceCreationFile())
        .map(value =>
          zio.aws.iotwireless.model.primitives.DeviceCreationFile(value)
        )
    override val role: Optional[Role] = zio.aws.core.internal
      .optionalFromNullable(impl.role())
      .map(value => zio.aws.iotwireless.model.primitives.Role(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.SidewalkStartImportInfo
  ): zio.aws.iotwireless.model.SidewalkStartImportInfo.ReadOnly = new Wrapper(
    impl
  )
}
