package zio.aws.iotwireless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class MessageDeliveryStatusResourceTypeEventConfiguration(
    sidewalk: Optional[
      zio.aws.iotwireless.model.SidewalkResourceTypeEventConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.MessageDeliveryStatusResourceTypeEventConfiguration = {
    import MessageDeliveryStatusResourceTypeEventConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.MessageDeliveryStatusResourceTypeEventConfiguration
      .builder()
      .optionallyWith(sidewalk.map(value => value.buildAwsValue()))(_.sidewalk)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.MessageDeliveryStatusResourceTypeEventConfiguration.ReadOnly =
    zio.aws.iotwireless.model.MessageDeliveryStatusResourceTypeEventConfiguration
      .wrap(buildAwsValue())
}
object MessageDeliveryStatusResourceTypeEventConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.MessageDeliveryStatusResourceTypeEventConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotwireless.model.MessageDeliveryStatusResourceTypeEventConfiguration =
      zio.aws.iotwireless.model
        .MessageDeliveryStatusResourceTypeEventConfiguration(
          sidewalk.map(value => value.asEditable)
        )
    def sidewalk: Optional[
      zio.aws.iotwireless.model.SidewalkResourceTypeEventConfiguration.ReadOnly
    ]
    def getSidewalk: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.SidewalkResourceTypeEventConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("sidewalk", sidewalk)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.MessageDeliveryStatusResourceTypeEventConfiguration
  ) extends zio.aws.iotwireless.model.MessageDeliveryStatusResourceTypeEventConfiguration.ReadOnly {
    override val sidewalk: Optional[
      zio.aws.iotwireless.model.SidewalkResourceTypeEventConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sidewalk())
      .map(value =>
        zio.aws.iotwireless.model.SidewalkResourceTypeEventConfiguration
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.MessageDeliveryStatusResourceTypeEventConfiguration
  ): zio.aws.iotwireless.model.MessageDeliveryStatusResourceTypeEventConfiguration.ReadOnly =
    new Wrapper(impl)
}
