package zio.aws.iotwireless.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iotwireless.model.primitives.{
  DlFreq,
  DlDr,
  PingSlotPeriod,
  SessionTimeout,
  SessionStartTimeTimestamp
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class LoRaWANMulticastSession(
    dlDr: Optional[DlDr] = Optional.Absent,
    dlFreq: Optional[DlFreq] = Optional.Absent,
    sessionStartTime: Optional[SessionStartTimeTimestamp] = Optional.Absent,
    sessionTimeout: Optional[SessionTimeout] = Optional.Absent,
    pingSlotPeriod: Optional[PingSlotPeriod] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.LoRaWANMulticastSession = {
    import LoRaWANMulticastSession.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.LoRaWANMulticastSession
      .builder()
      .optionallyWith(dlDr.map(value => DlDr.unwrap(value): Integer))(_.dlDr)
      .optionallyWith(dlFreq.map(value => DlFreq.unwrap(value): Integer))(
        _.dlFreq
      )
      .optionallyWith(
        sessionStartTime.map(value =>
          SessionStartTimeTimestamp.unwrap(value): Instant
        )
      )(_.sessionStartTime)
      .optionallyWith(
        sessionTimeout.map(value => SessionTimeout.unwrap(value): Integer)
      )(_.sessionTimeout)
      .optionallyWith(
        pingSlotPeriod.map(value => PingSlotPeriod.unwrap(value): Integer)
      )(_.pingSlotPeriod)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.LoRaWANMulticastSession.ReadOnly =
    zio.aws.iotwireless.model.LoRaWANMulticastSession.wrap(buildAwsValue())
}
object LoRaWANMulticastSession {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.LoRaWANMulticastSession
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.LoRaWANMulticastSession =
      zio.aws.iotwireless.model.LoRaWANMulticastSession(
        dlDr.map(value => value),
        dlFreq.map(value => value),
        sessionStartTime.map(value => value),
        sessionTimeout.map(value => value),
        pingSlotPeriod.map(value => value)
      )
    def dlDr: Optional[DlDr]
    def dlFreq: Optional[DlFreq]
    def sessionStartTime: Optional[SessionStartTimeTimestamp]
    def sessionTimeout: Optional[SessionTimeout]
    def pingSlotPeriod: Optional[PingSlotPeriod]
    def getDlDr: ZIO[Any, AwsError, DlDr] =
      AwsError.unwrapOptionField("dlDr", dlDr)
    def getDlFreq: ZIO[Any, AwsError, DlFreq] =
      AwsError.unwrapOptionField("dlFreq", dlFreq)
    def getSessionStartTime: ZIO[Any, AwsError, SessionStartTimeTimestamp] =
      AwsError.unwrapOptionField("sessionStartTime", sessionStartTime)
    def getSessionTimeout: ZIO[Any, AwsError, SessionTimeout] =
      AwsError.unwrapOptionField("sessionTimeout", sessionTimeout)
    def getPingSlotPeriod: ZIO[Any, AwsError, PingSlotPeriod] =
      AwsError.unwrapOptionField("pingSlotPeriod", pingSlotPeriod)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.LoRaWANMulticastSession
  ) extends zio.aws.iotwireless.model.LoRaWANMulticastSession.ReadOnly {
    override val dlDr: Optional[DlDr] = zio.aws.core.internal
      .optionalFromNullable(impl.dlDr())
      .map(value => zio.aws.iotwireless.model.primitives.DlDr(value))
    override val dlFreq: Optional[DlFreq] = zio.aws.core.internal
      .optionalFromNullable(impl.dlFreq())
      .map(value => zio.aws.iotwireless.model.primitives.DlFreq(value))
    override val sessionStartTime: Optional[SessionStartTimeTimestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sessionStartTime())
        .map(value =>
          zio.aws.iotwireless.model.primitives.SessionStartTimeTimestamp(value)
        )
    override val sessionTimeout: Optional[SessionTimeout] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sessionTimeout())
        .map(value =>
          zio.aws.iotwireless.model.primitives.SessionTimeout(value)
        )
    override val pingSlotPeriod: Optional[PingSlotPeriod] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pingSlotPeriod())
        .map(value =>
          zio.aws.iotwireless.model.primitives.PingSlotPeriod(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.LoRaWANMulticastSession
  ): zio.aws.iotwireless.model.LoRaWANMulticastSession.ReadOnly = new Wrapper(
    impl
  )
}
