package zio.aws.iotwireless.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iotwireless.model.primitives.{NextToken, MaxResults}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListWirelessGatewayTaskDefinitionsRequest(
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    taskDefinitionType: Optional[
      zio.aws.iotwireless.model.WirelessGatewayTaskDefinitionType
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.ListWirelessGatewayTaskDefinitionsRequest = {
    import ListWirelessGatewayTaskDefinitionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.ListWirelessGatewayTaskDefinitionsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(taskDefinitionType.map(value => value.unwrap))(
        _.taskDefinitionType
      )
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.ListWirelessGatewayTaskDefinitionsRequest.ReadOnly =
    zio.aws.iotwireless.model.ListWirelessGatewayTaskDefinitionsRequest
      .wrap(buildAwsValue())
}
object ListWirelessGatewayTaskDefinitionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.ListWirelessGatewayTaskDefinitionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotwireless.model.ListWirelessGatewayTaskDefinitionsRequest =
      zio.aws.iotwireless.model.ListWirelessGatewayTaskDefinitionsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        taskDefinitionType.map(value => value)
      )
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def taskDefinitionType
        : Optional[zio.aws.iotwireless.model.WirelessGatewayTaskDefinitionType]
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getTaskDefinitionType: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.WirelessGatewayTaskDefinitionType
    ] = AwsError.unwrapOptionField("taskDefinitionType", taskDefinitionType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.ListWirelessGatewayTaskDefinitionsRequest
  ) extends zio.aws.iotwireless.model.ListWirelessGatewayTaskDefinitionsRequest.ReadOnly {
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.iotwireless.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iotwireless.model.primitives.NextToken(value))
    override val taskDefinitionType: Optional[
      zio.aws.iotwireless.model.WirelessGatewayTaskDefinitionType
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.taskDefinitionType())
      .map(value =>
        zio.aws.iotwireless.model.WirelessGatewayTaskDefinitionType.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.ListWirelessGatewayTaskDefinitionsRequest
  ): zio.aws.iotwireless.model.ListWirelessGatewayTaskDefinitionsRequest.ReadOnly =
    new Wrapper(impl)
}
