package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.Identifier
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetWirelessDeviceRequest(
    identifier: Identifier,
    identifierType: zio.aws.iotwireless.model.WirelessDeviceIdType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.GetWirelessDeviceRequest = {
    import GetWirelessDeviceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.GetWirelessDeviceRequest
      .builder()
      .identifier(Identifier.unwrap(identifier): java.lang.String)
      .identifierType(identifierType.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.GetWirelessDeviceRequest.ReadOnly =
    zio.aws.iotwireless.model.GetWirelessDeviceRequest.wrap(buildAwsValue())
}
object GetWirelessDeviceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.GetWirelessDeviceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.GetWirelessDeviceRequest =
      zio.aws.iotwireless.model
        .GetWirelessDeviceRequest(identifier, identifierType)
    def identifier: Identifier
    def identifierType: zio.aws.iotwireless.model.WirelessDeviceIdType
    def getIdentifier: ZIO[Any, Nothing, Identifier] = ZIO.succeed(identifier)
    def getIdentifierType
        : ZIO[Any, Nothing, zio.aws.iotwireless.model.WirelessDeviceIdType] =
      ZIO.succeed(identifierType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.GetWirelessDeviceRequest
  ) extends zio.aws.iotwireless.model.GetWirelessDeviceRequest.ReadOnly {
    override val identifier: Identifier =
      zio.aws.iotwireless.model.primitives.Identifier(impl.identifier())
    override val identifierType
        : zio.aws.iotwireless.model.WirelessDeviceIdType =
      zio.aws.iotwireless.model.WirelessDeviceIdType.wrap(impl.identifierType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.GetWirelessDeviceRequest
  ): zio.aws.iotwireless.model.GetWirelessDeviceRequest.ReadOnly = new Wrapper(
    impl
  )
}
