package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.GeoJsonPayload
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetResourcePositionResponse(
    geoJsonPayload: Optional[GeoJsonPayload] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.GetResourcePositionResponse = {
    import GetResourcePositionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.GetResourcePositionResponse
      .builder()
      .optionallyWith(
        geoJsonPayload.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.geoJsonPayload)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.GetResourcePositionResponse.ReadOnly =
    zio.aws.iotwireless.model.GetResourcePositionResponse.wrap(buildAwsValue())
}
object GetResourcePositionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.GetResourcePositionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.GetResourcePositionResponse =
      zio.aws.iotwireless.model
        .GetResourcePositionResponse(geoJsonPayload.map(value => value))
    def geoJsonPayload: Optional[GeoJsonPayload]
    def getGeoJsonPayload: ZIO[Any, AwsError, GeoJsonPayload] =
      AwsError.unwrapOptionField("geoJsonPayload", geoJsonPayload)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.GetResourcePositionResponse
  ) extends zio.aws.iotwireless.model.GetResourcePositionResponse.ReadOnly {
    override val geoJsonPayload: Optional[GeoJsonPayload] =
      zio.aws.core.internal
        .optionalFromNullable(impl.geoJsonPayload())
        .map(value =>
          zio.aws.iotwireless.model.primitives
            .GeoJsonPayload(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.GetResourcePositionResponse
  ): zio.aws.iotwireless.model.GetResourcePositionResponse.ReadOnly =
    new Wrapper(impl)
}
