package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.PartnerAccountId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetPartnerAccountRequest(
    partnerAccountId: PartnerAccountId,
    partnerType: zio.aws.iotwireless.model.PartnerType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.GetPartnerAccountRequest = {
    import GetPartnerAccountRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.GetPartnerAccountRequest
      .builder()
      .partnerAccountId(
        PartnerAccountId.unwrap(partnerAccountId): java.lang.String
      )
      .partnerType(partnerType.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.GetPartnerAccountRequest.ReadOnly =
    zio.aws.iotwireless.model.GetPartnerAccountRequest.wrap(buildAwsValue())
}
object GetPartnerAccountRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.GetPartnerAccountRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.GetPartnerAccountRequest =
      zio.aws.iotwireless.model
        .GetPartnerAccountRequest(partnerAccountId, partnerType)
    def partnerAccountId: PartnerAccountId
    def partnerType: zio.aws.iotwireless.model.PartnerType
    def getPartnerAccountId: ZIO[Any, Nothing, PartnerAccountId] =
      ZIO.succeed(partnerAccountId)
    def getPartnerType
        : ZIO[Any, Nothing, zio.aws.iotwireless.model.PartnerType] =
      ZIO.succeed(partnerType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.GetPartnerAccountRequest
  ) extends zio.aws.iotwireless.model.GetPartnerAccountRequest.ReadOnly {
    override val partnerAccountId: PartnerAccountId =
      zio.aws.iotwireless.model.primitives
        .PartnerAccountId(impl.partnerAccountId())
    override val partnerType: zio.aws.iotwireless.model.PartnerType =
      zio.aws.iotwireless.model.PartnerType.wrap(impl.partnerType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.GetPartnerAccountRequest
  ): zio.aws.iotwireless.model.GetPartnerAccountRequest.ReadOnly = new Wrapper(
    impl
  )
}
