package zio.aws.iotwireless.model
import scala.jdk.CollectionConverters._
sealed trait Event {
  def unwrap: software.amazon.awssdk.services.iotwireless.model.Event
}
object Event {
  def wrap(
      value: software.amazon.awssdk.services.iotwireless.model.Event
  ): zio.aws.iotwireless.model.Event = value match {
    case software.amazon.awssdk.services.iotwireless.model.Event.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotwireless.model.Event.DISCOVERED =>
      val r = discovered
      r
    case software.amazon.awssdk.services.iotwireless.model.Event.LOST =>
      val r = lost
      r
    case software.amazon.awssdk.services.iotwireless.model.Event.ACK =>
      val r = ack
      r
    case software.amazon.awssdk.services.iotwireless.model.Event.NACK =>
      val r = nack
      r
    case software.amazon.awssdk.services.iotwireless.model.Event.PASSTHROUGH =>
      val r = passthrough
      r
  }
  case object unknownToSdkVersion extends zio.aws.iotwireless.model.Event {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.Event =
      software.amazon.awssdk.services.iotwireless.model.Event.UNKNOWN_TO_SDK_VERSION
  }
  case object discovered extends zio.aws.iotwireless.model.Event {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.Event =
      software.amazon.awssdk.services.iotwireless.model.Event.DISCOVERED
  }
  case object lost extends zio.aws.iotwireless.model.Event {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.Event =
      software.amazon.awssdk.services.iotwireless.model.Event.LOST
  }
  case object ack extends zio.aws.iotwireless.model.Event {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.Event =
      software.amazon.awssdk.services.iotwireless.model.Event.ACK
  }
  case object nack extends zio.aws.iotwireless.model.Event {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.Event =
      software.amazon.awssdk.services.iotwireless.model.Event.NACK
  }
  case object passthrough extends zio.aws.iotwireless.model.Event {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.Event =
      software.amazon.awssdk.services.iotwireless.model.Event.PASSTHROUGH
  }
}
