package zio.aws.iotwireless.model
import scala.jdk.CollectionConverters._
sealed trait DlClass {
  def unwrap: software.amazon.awssdk.services.iotwireless.model.DlClass
}
object DlClass {
  def wrap(
      value: software.amazon.awssdk.services.iotwireless.model.DlClass
  ): zio.aws.iotwireless.model.DlClass = value match {
    case software.amazon.awssdk.services.iotwireless.model.DlClass.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotwireless.model.DlClass.CLASSB =>
      val r = ClassB
      r
    case software.amazon.awssdk.services.iotwireless.model.DlClass.CLASSC =>
      val r = ClassC
      r
  }
  case object unknownToSdkVersion extends zio.aws.iotwireless.model.DlClass {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.DlClass =
      software.amazon.awssdk.services.iotwireless.model.DlClass.UNKNOWN_TO_SDK_VERSION
  }
  case object ClassB extends zio.aws.iotwireless.model.DlClass {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.DlClass =
      software.amazon.awssdk.services.iotwireless.model.DlClass.CLASSB
  }
  case object ClassC extends zio.aws.iotwireless.model.DlClass {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.DlClass =
      software.amazon.awssdk.services.iotwireless.model.DlClass.CLASSC
  }
}
