package zio.aws.iotwireless.model
import scala.jdk.CollectionConverters._
sealed trait BatteryLevel {
  def unwrap: software.amazon.awssdk.services.iotwireless.model.BatteryLevel
}
object BatteryLevel {
  def wrap(
      value: software.amazon.awssdk.services.iotwireless.model.BatteryLevel
  ): zio.aws.iotwireless.model.BatteryLevel = value match {
    case software.amazon.awssdk.services.iotwireless.model.BatteryLevel.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotwireless.model.BatteryLevel.NORMAL =>
      val r = normal
      r
    case software.amazon.awssdk.services.iotwireless.model.BatteryLevel.LOW =>
      val r = low
      r
    case software.amazon.awssdk.services.iotwireless.model.BatteryLevel.CRITICAL =>
      val r = critical
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iotwireless.model.BatteryLevel {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.BatteryLevel =
      software.amazon.awssdk.services.iotwireless.model.BatteryLevel.UNKNOWN_TO_SDK_VERSION
  }
  case object normal extends zio.aws.iotwireless.model.BatteryLevel {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.BatteryLevel =
      software.amazon.awssdk.services.iotwireless.model.BatteryLevel.NORMAL
  }
  case object low extends zio.aws.iotwireless.model.BatteryLevel {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.BatteryLevel =
      software.amazon.awssdk.services.iotwireless.model.BatteryLevel.LOW
  }
  case object critical extends zio.aws.iotwireless.model.BatteryLevel {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.BatteryLevel =
      software.amazon.awssdk.services.iotwireless.model.BatteryLevel.CRITICAL
  }
}
