package zio.aws.iotwireless.model
import scala.jdk.CollectionConverters._
sealed trait WirelessGatewayServiceType {
  def unwrap: software.amazon.awssdk.services.iotwireless.model.WirelessGatewayServiceType
}
object WirelessGatewayServiceType {
  def wrap(
      value: software.amazon.awssdk.services.iotwireless.model.WirelessGatewayServiceType
  ): zio.aws.iotwireless.model.WirelessGatewayServiceType = value match {
    case software.amazon.awssdk.services.iotwireless.model.WirelessGatewayServiceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotwireless.model.WirelessGatewayServiceType.CUPS =>
      val r = CUPS
      r
    case software.amazon.awssdk.services.iotwireless.model.WirelessGatewayServiceType.LNS =>
      val r = LNS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iotwireless.model.WirelessGatewayServiceType {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.WirelessGatewayServiceType =
      software.amazon.awssdk.services.iotwireless.model.WirelessGatewayServiceType.UNKNOWN_TO_SDK_VERSION
  }
  case object CUPS
      extends zio.aws.iotwireless.model.WirelessGatewayServiceType {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.WirelessGatewayServiceType =
      software.amazon.awssdk.services.iotwireless.model.WirelessGatewayServiceType.CUPS
  }
  case object LNS extends zio.aws.iotwireless.model.WirelessGatewayServiceType {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.WirelessGatewayServiceType =
      software.amazon.awssdk.services.iotwireless.model.WirelessGatewayServiceType.LNS
  }
}
