package zio.aws.iotwireless.model
import scala.jdk.CollectionConverters._
sealed trait WirelessDeviceFrameInfo {
  def unwrap: software.amazon.awssdk.services.iotwireless.model.WirelessDeviceFrameInfo
}
object WirelessDeviceFrameInfo {
  def wrap(
      value: software.amazon.awssdk.services.iotwireless.model.WirelessDeviceFrameInfo
  ): zio.aws.iotwireless.model.WirelessDeviceFrameInfo = value match {
    case software.amazon.awssdk.services.iotwireless.model.WirelessDeviceFrameInfo.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotwireless.model.WirelessDeviceFrameInfo.ENABLED =>
      val r = ENABLED
      r
    case software.amazon.awssdk.services.iotwireless.model.WirelessDeviceFrameInfo.DISABLED =>
      val r = DISABLED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iotwireless.model.WirelessDeviceFrameInfo {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.WirelessDeviceFrameInfo =
      software.amazon.awssdk.services.iotwireless.model.WirelessDeviceFrameInfo.UNKNOWN_TO_SDK_VERSION
  }
  case object ENABLED
      extends zio.aws.iotwireless.model.WirelessDeviceFrameInfo {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.WirelessDeviceFrameInfo =
      software.amazon.awssdk.services.iotwireless.model.WirelessDeviceFrameInfo.ENABLED
  }
  case object DISABLED
      extends zio.aws.iotwireless.model.WirelessDeviceFrameInfo {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.WirelessDeviceFrameInfo =
      software.amazon.awssdk.services.iotwireless.model.WirelessDeviceFrameInfo.DISABLED
  }
}
