package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{
  GatewayMaxEirp,
  WirelessGatewayId,
  WirelessGatewayName,
  NetId,
  Description,
  JoinEui
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateWirelessGatewayRequest(
    id: WirelessGatewayId,
    name: Optional[WirelessGatewayName] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    joinEuiFilters: Optional[Iterable[Iterable[JoinEui]]] = Optional.Absent,
    netIdFilters: Optional[Iterable[NetId]] = Optional.Absent,
    maxEirp: Optional[GatewayMaxEirp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.UpdateWirelessGatewayRequest = {
    import UpdateWirelessGatewayRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.UpdateWirelessGatewayRequest
      .builder()
      .id(WirelessGatewayId.unwrap(id): java.lang.String)
      .optionallyWith(
        name.map(value => WirelessGatewayName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        joinEuiFilters.map(value =>
          value.map { item =>
            item.map { item =>
              JoinEui.unwrap(item): java.lang.String
            }.asJavaCollection
          }.asJavaCollection
        )
      )(_.joinEuiFilters)
      .optionallyWith(
        netIdFilters.map(value =>
          value.map { item =>
            NetId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.netIdFilters)
      .optionallyWith(
        maxEirp.map(value => GatewayMaxEirp.unwrap(value): java.lang.Float)
      )(_.maxEirp)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.UpdateWirelessGatewayRequest.ReadOnly =
    zio.aws.iotwireless.model.UpdateWirelessGatewayRequest.wrap(buildAwsValue())
}
object UpdateWirelessGatewayRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.UpdateWirelessGatewayRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.UpdateWirelessGatewayRequest =
      zio.aws.iotwireless.model.UpdateWirelessGatewayRequest(
        id,
        name.map(value => value),
        description.map(value => value),
        joinEuiFilters.map(value => value),
        netIdFilters.map(value => value),
        maxEirp.map(value => value)
      )
    def id: WirelessGatewayId
    def name: Optional[WirelessGatewayName]
    def description: Optional[Description]
    def joinEuiFilters: Optional[List[List[JoinEui]]]
    def netIdFilters: Optional[List[NetId]]
    def maxEirp: Optional[GatewayMaxEirp]
    def getId: ZIO[Any, Nothing, WirelessGatewayId] = ZIO.succeed(id)
    def getName: ZIO[Any, AwsError, WirelessGatewayName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getJoinEuiFilters: ZIO[Any, AwsError, List[List[JoinEui]]] =
      AwsError.unwrapOptionField("joinEuiFilters", joinEuiFilters)
    def getNetIdFilters: ZIO[Any, AwsError, List[NetId]] =
      AwsError.unwrapOptionField("netIdFilters", netIdFilters)
    def getMaxEirp: ZIO[Any, AwsError, GatewayMaxEirp] =
      AwsError.unwrapOptionField("maxEirp", maxEirp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.UpdateWirelessGatewayRequest
  ) extends zio.aws.iotwireless.model.UpdateWirelessGatewayRequest.ReadOnly {
    override val id: WirelessGatewayId =
      zio.aws.iotwireless.model.primitives.WirelessGatewayId(impl.id())
    override val name: Optional[WirelessGatewayName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.iotwireless.model.primitives.WirelessGatewayName(value)
      )
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.iotwireless.model.primitives.Description(value))
    override val joinEuiFilters: Optional[List[List[JoinEui]]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.joinEuiFilters())
        .map(value =>
          value.asScala.map { item =>
            item.asScala.map { item =>
              zio.aws.iotwireless.model.primitives.JoinEui(item)
            }.toList
          }.toList
        )
    override val netIdFilters: Optional[List[NetId]] = zio.aws.core.internal
      .optionalFromNullable(impl.netIdFilters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotwireless.model.primitives.NetId(item)
        }.toList
      )
    override val maxEirp: Optional[GatewayMaxEirp] = zio.aws.core.internal
      .optionalFromNullable(impl.maxEirp())
      .map(value => zio.aws.iotwireless.model.primitives.GatewayMaxEirp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.UpdateWirelessGatewayRequest
  ): zio.aws.iotwireless.model.UpdateWirelessGatewayRequest.ReadOnly =
    new Wrapper(impl)
}
