package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{
  GeoJsonPayload,
  PositionResourceIdentifier
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateResourcePositionRequest(
    resourceIdentifier: PositionResourceIdentifier,
    resourceType: zio.aws.iotwireless.model.PositionResourceType,
    geoJsonPayload: Optional[GeoJsonPayload] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.UpdateResourcePositionRequest = {
    import UpdateResourcePositionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.UpdateResourcePositionRequest
      .builder()
      .resourceIdentifier(
        PositionResourceIdentifier.unwrap(resourceIdentifier): java.lang.String
      )
      .resourceType(resourceType.unwrap)
      .optionallyWith(
        geoJsonPayload.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.geoJsonPayload)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.UpdateResourcePositionRequest.ReadOnly =
    zio.aws.iotwireless.model.UpdateResourcePositionRequest
      .wrap(buildAwsValue())
}
object UpdateResourcePositionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.UpdateResourcePositionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.UpdateResourcePositionRequest =
      zio.aws.iotwireless.model.UpdateResourcePositionRequest(
        resourceIdentifier,
        resourceType,
        geoJsonPayload.map(value => value)
      )
    def resourceIdentifier: PositionResourceIdentifier
    def resourceType: zio.aws.iotwireless.model.PositionResourceType
    def geoJsonPayload: Optional[GeoJsonPayload]
    def getResourceIdentifier: ZIO[Any, Nothing, PositionResourceIdentifier] =
      ZIO.succeed(resourceIdentifier)
    def getResourceType
        : ZIO[Any, Nothing, zio.aws.iotwireless.model.PositionResourceType] =
      ZIO.succeed(resourceType)
    def getGeoJsonPayload: ZIO[Any, AwsError, GeoJsonPayload] =
      AwsError.unwrapOptionField("geoJsonPayload", geoJsonPayload)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.UpdateResourcePositionRequest
  ) extends zio.aws.iotwireless.model.UpdateResourcePositionRequest.ReadOnly {
    override val resourceIdentifier: PositionResourceIdentifier =
      zio.aws.iotwireless.model.primitives
        .PositionResourceIdentifier(impl.resourceIdentifier())
    override val resourceType: zio.aws.iotwireless.model.PositionResourceType =
      zio.aws.iotwireless.model.PositionResourceType.wrap(impl.resourceType())
    override val geoJsonPayload: Optional[GeoJsonPayload] =
      zio.aws.core.internal
        .optionalFromNullable(impl.geoJsonPayload())
        .map(value =>
          zio.aws.iotwireless.model.primitives
            .GeoJsonPayload(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.UpdateResourcePositionRequest
  ): zio.aws.iotwireless.model.UpdateResourcePositionRequest.ReadOnly =
    new Wrapper(impl)
}
