package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.DeviceProfileId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SidewalkCreateWirelessDevice(
    deviceProfileId: Optional[DeviceProfileId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.SidewalkCreateWirelessDevice = {
    import SidewalkCreateWirelessDevice.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.SidewalkCreateWirelessDevice
      .builder()
      .optionallyWith(
        deviceProfileId.map(value =>
          DeviceProfileId.unwrap(value): java.lang.String
        )
      )(_.deviceProfileId)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.SidewalkCreateWirelessDevice.ReadOnly =
    zio.aws.iotwireless.model.SidewalkCreateWirelessDevice.wrap(buildAwsValue())
}
object SidewalkCreateWirelessDevice {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.SidewalkCreateWirelessDevice
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.SidewalkCreateWirelessDevice =
      zio.aws.iotwireless.model
        .SidewalkCreateWirelessDevice(deviceProfileId.map(value => value))
    def deviceProfileId: Optional[DeviceProfileId]
    def getDeviceProfileId: ZIO[Any, AwsError, DeviceProfileId] =
      AwsError.unwrapOptionField("deviceProfileId", deviceProfileId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.SidewalkCreateWirelessDevice
  ) extends zio.aws.iotwireless.model.SidewalkCreateWirelessDevice.ReadOnly {
    override val deviceProfileId: Optional[DeviceProfileId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deviceProfileId())
        .map(value =>
          zio.aws.iotwireless.model.primitives.DeviceProfileId(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.SidewalkCreateWirelessDevice
  ): zio.aws.iotwireless.model.SidewalkCreateWirelessDevice.ReadOnly =
    new Wrapper(impl)
}
