package zio.aws.iotwireless.model
import scala.jdk.CollectionConverters._
sealed trait PartnerType {
  def unwrap: software.amazon.awssdk.services.iotwireless.model.PartnerType
}
object PartnerType {
  def wrap(
      value: software.amazon.awssdk.services.iotwireless.model.PartnerType
  ): zio.aws.iotwireless.model.PartnerType = value match {
    case software.amazon.awssdk.services.iotwireless.model.PartnerType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotwireless.model.PartnerType.SIDEWALK =>
      val r = Sidewalk
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iotwireless.model.PartnerType {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.PartnerType =
      software.amazon.awssdk.services.iotwireless.model.PartnerType.UNKNOWN_TO_SDK_VERSION
  }
  case object Sidewalk extends zio.aws.iotwireless.model.PartnerType {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.PartnerType =
      software.amazon.awssdk.services.iotwireless.model.PartnerType.SIDEWALK
  }
}
