package zio.aws.iotwireless.model
import java.lang.Integer
import zio.aws.iotwireless.model.primitives.{EARFCN, PCI}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class LteLocalId(pci: PCI, earfcn: EARFCN) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.LteLocalId = {
    import LteLocalId.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.LteLocalId
      .builder()
      .pci(PCI.unwrap(pci): Integer)
      .earfcn(EARFCN.unwrap(earfcn): Integer)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.LteLocalId.ReadOnly =
    zio.aws.iotwireless.model.LteLocalId.wrap(buildAwsValue())
}
object LteLocalId {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.LteLocalId
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.LteLocalId =
      zio.aws.iotwireless.model.LteLocalId(pci, earfcn)
    def pci: PCI
    def earfcn: EARFCN
    def getPci: ZIO[Any, Nothing, PCI] = ZIO.succeed(pci)
    def getEarfcn: ZIO[Any, Nothing, EARFCN] = ZIO.succeed(earfcn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.LteLocalId
  ) extends zio.aws.iotwireless.model.LteLocalId.ReadOnly {
    override val pci: PCI = zio.aws.iotwireless.model.primitives.PCI(impl.pci())
    override val earfcn: EARFCN =
      zio.aws.iotwireless.model.primitives.EARFCN(impl.earfcn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.LteLocalId
  ): zio.aws.iotwireless.model.LteLocalId.ReadOnly = new Wrapper(impl)
}
