package zio.aws.iotwireless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class LoRaWANUpdateGatewayTaskEntry(
    currentVersion: Optional[zio.aws.iotwireless.model.LoRaWANGatewayVersion] =
      Optional.Absent,
    updateVersion: Optional[zio.aws.iotwireless.model.LoRaWANGatewayVersion] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.LoRaWANUpdateGatewayTaskEntry = {
    import LoRaWANUpdateGatewayTaskEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.LoRaWANUpdateGatewayTaskEntry
      .builder()
      .optionallyWith(currentVersion.map(value => value.buildAwsValue()))(
        _.currentVersion
      )
      .optionallyWith(updateVersion.map(value => value.buildAwsValue()))(
        _.updateVersion
      )
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.LoRaWANUpdateGatewayTaskEntry.ReadOnly =
    zio.aws.iotwireless.model.LoRaWANUpdateGatewayTaskEntry
      .wrap(buildAwsValue())
}
object LoRaWANUpdateGatewayTaskEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.LoRaWANUpdateGatewayTaskEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.LoRaWANUpdateGatewayTaskEntry =
      zio.aws.iotwireless.model.LoRaWANUpdateGatewayTaskEntry(
        currentVersion.map(value => value.asEditable),
        updateVersion.map(value => value.asEditable)
      )
    def currentVersion
        : Optional[zio.aws.iotwireless.model.LoRaWANGatewayVersion.ReadOnly]
    def updateVersion
        : Optional[zio.aws.iotwireless.model.LoRaWANGatewayVersion.ReadOnly]
    def getCurrentVersion: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.LoRaWANGatewayVersion.ReadOnly
    ] = AwsError.unwrapOptionField("currentVersion", currentVersion)
    def getUpdateVersion: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.LoRaWANGatewayVersion.ReadOnly
    ] = AwsError.unwrapOptionField("updateVersion", updateVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.LoRaWANUpdateGatewayTaskEntry
  ) extends zio.aws.iotwireless.model.LoRaWANUpdateGatewayTaskEntry.ReadOnly {
    override val currentVersion
        : Optional[zio.aws.iotwireless.model.LoRaWANGatewayVersion.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.currentVersion())
        .map(value =>
          zio.aws.iotwireless.model.LoRaWANGatewayVersion.wrap(value)
        )
    override val updateVersion
        : Optional[zio.aws.iotwireless.model.LoRaWANGatewayVersion.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.updateVersion())
        .map(value =>
          zio.aws.iotwireless.model.LoRaWANGatewayVersion.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.LoRaWANUpdateGatewayTaskEntry
  ): zio.aws.iotwireless.model.LoRaWANUpdateGatewayTaskEntry.ReadOnly =
    new Wrapper(impl)
}
