package zio.aws.iotwireless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class LoRaWANMulticast(
    rfRegion: Optional[zio.aws.iotwireless.model.SupportedRfRegion] =
      Optional.Absent,
    dlClass: Optional[zio.aws.iotwireless.model.DlClass] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.LoRaWANMulticast = {
    import LoRaWANMulticast.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.LoRaWANMulticast
      .builder()
      .optionallyWith(rfRegion.map(value => value.unwrap))(_.rfRegion)
      .optionallyWith(dlClass.map(value => value.unwrap))(_.dlClass)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.LoRaWANMulticast.ReadOnly =
    zio.aws.iotwireless.model.LoRaWANMulticast.wrap(buildAwsValue())
}
object LoRaWANMulticast {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.LoRaWANMulticast
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.LoRaWANMulticast =
      zio.aws.iotwireless.model.LoRaWANMulticast(
        rfRegion.map(value => value),
        dlClass.map(value => value)
      )
    def rfRegion: Optional[zio.aws.iotwireless.model.SupportedRfRegion]
    def dlClass: Optional[zio.aws.iotwireless.model.DlClass]
    def getRfRegion
        : ZIO[Any, AwsError, zio.aws.iotwireless.model.SupportedRfRegion] =
      AwsError.unwrapOptionField("rfRegion", rfRegion)
    def getDlClass: ZIO[Any, AwsError, zio.aws.iotwireless.model.DlClass] =
      AwsError.unwrapOptionField("dlClass", dlClass)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.LoRaWANMulticast
  ) extends zio.aws.iotwireless.model.LoRaWANMulticast.ReadOnly {
    override val rfRegion
        : Optional[zio.aws.iotwireless.model.SupportedRfRegion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rfRegion())
        .map(value => zio.aws.iotwireless.model.SupportedRfRegion.wrap(value))
    override val dlClass: Optional[zio.aws.iotwireless.model.DlClass] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dlClass())
        .map(value => zio.aws.iotwireless.model.DlClass.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.LoRaWANMulticast
  ): zio.aws.iotwireless.model.LoRaWANMulticast.ReadOnly = new Wrapper(impl)
}
