package zio.aws.iotwireless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class LoRaWANJoinEventNotificationConfigurations(
    devEuiEventTopic: Optional[
      zio.aws.iotwireless.model.EventNotificationTopicStatus
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.LoRaWANJoinEventNotificationConfigurations = {
    import LoRaWANJoinEventNotificationConfigurations.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.LoRaWANJoinEventNotificationConfigurations
      .builder()
      .optionallyWith(devEuiEventTopic.map(value => value.unwrap))(
        _.devEuiEventTopic
      )
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.LoRaWANJoinEventNotificationConfigurations.ReadOnly =
    zio.aws.iotwireless.model.LoRaWANJoinEventNotificationConfigurations
      .wrap(buildAwsValue())
}
object LoRaWANJoinEventNotificationConfigurations {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.LoRaWANJoinEventNotificationConfigurations
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotwireless.model.LoRaWANJoinEventNotificationConfigurations =
      zio.aws.iotwireless.model.LoRaWANJoinEventNotificationConfigurations(
        devEuiEventTopic.map(value => value)
      )
    def devEuiEventTopic
        : Optional[zio.aws.iotwireless.model.EventNotificationTopicStatus]
    def getDevEuiEventTopic: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.EventNotificationTopicStatus
    ] = AwsError.unwrapOptionField("devEuiEventTopic", devEuiEventTopic)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.LoRaWANJoinEventNotificationConfigurations
  ) extends zio.aws.iotwireless.model.LoRaWANJoinEventNotificationConfigurations.ReadOnly {
    override val devEuiEventTopic
        : Optional[zio.aws.iotwireless.model.EventNotificationTopicStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.devEuiEventTopic())
        .map(value =>
          zio.aws.iotwireless.model.EventNotificationTopicStatus.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.LoRaWANJoinEventNotificationConfigurations
  ): zio.aws.iotwireless.model.LoRaWANJoinEventNotificationConfigurations.ReadOnly =
    new Wrapper(impl)
}
