package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListWirelessDeviceImportTasksResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    wirelessDeviceImportTaskList: Optional[
      Iterable[zio.aws.iotwireless.model.WirelessDeviceImportTask]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.ListWirelessDeviceImportTasksResponse = {
    import ListWirelessDeviceImportTasksResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.ListWirelessDeviceImportTasksResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        wirelessDeviceImportTaskList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.wirelessDeviceImportTaskList)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.ListWirelessDeviceImportTasksResponse.ReadOnly =
    zio.aws.iotwireless.model.ListWirelessDeviceImportTasksResponse
      .wrap(buildAwsValue())
}
object ListWirelessDeviceImportTasksResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.ListWirelessDeviceImportTasksResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotwireless.model.ListWirelessDeviceImportTasksResponse =
      zio.aws.iotwireless.model.ListWirelessDeviceImportTasksResponse(
        nextToken.map(value => value),
        wirelessDeviceImportTaskList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[NextToken]
    def wirelessDeviceImportTaskList: Optional[
      List[zio.aws.iotwireless.model.WirelessDeviceImportTask.ReadOnly]
    ]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getWirelessDeviceImportTaskList: ZIO[Any, AwsError, List[
      zio.aws.iotwireless.model.WirelessDeviceImportTask.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "wirelessDeviceImportTaskList",
      wirelessDeviceImportTaskList
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.ListWirelessDeviceImportTasksResponse
  ) extends zio.aws.iotwireless.model.ListWirelessDeviceImportTasksResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iotwireless.model.primitives.NextToken(value))
    override val wirelessDeviceImportTaskList: Optional[
      List[zio.aws.iotwireless.model.WirelessDeviceImportTask.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.wirelessDeviceImportTaskList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotwireless.model.WirelessDeviceImportTask.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.ListWirelessDeviceImportTasksResponse
  ): zio.aws.iotwireless.model.ListWirelessDeviceImportTasksResponse.ReadOnly =
    new Wrapper(impl)
}
