package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{DestinationName, NextToken}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListDevicesForWirelessDeviceImportTaskResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    destinationName: Optional[DestinationName] = Optional.Absent,
    importedWirelessDeviceList: Optional[
      Iterable[zio.aws.iotwireless.model.ImportedWirelessDevice]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.ListDevicesForWirelessDeviceImportTaskResponse = {
    import ListDevicesForWirelessDeviceImportTaskResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.ListDevicesForWirelessDeviceImportTaskResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        destinationName.map(value =>
          DestinationName.unwrap(value): java.lang.String
        )
      )(_.destinationName)
      .optionallyWith(
        importedWirelessDeviceList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.importedWirelessDeviceList)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.ListDevicesForWirelessDeviceImportTaskResponse.ReadOnly =
    zio.aws.iotwireless.model.ListDevicesForWirelessDeviceImportTaskResponse
      .wrap(buildAwsValue())
}
object ListDevicesForWirelessDeviceImportTaskResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.ListDevicesForWirelessDeviceImportTaskResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotwireless.model.ListDevicesForWirelessDeviceImportTaskResponse =
      zio.aws.iotwireless.model.ListDevicesForWirelessDeviceImportTaskResponse(
        nextToken.map(value => value),
        destinationName.map(value => value),
        importedWirelessDeviceList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[NextToken]
    def destinationName: Optional[DestinationName]
    def importedWirelessDeviceList: Optional[
      List[zio.aws.iotwireless.model.ImportedWirelessDevice.ReadOnly]
    ]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getDestinationName: ZIO[Any, AwsError, DestinationName] =
      AwsError.unwrapOptionField("destinationName", destinationName)
    def getImportedWirelessDeviceList: ZIO[Any, AwsError, List[
      zio.aws.iotwireless.model.ImportedWirelessDevice.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "importedWirelessDeviceList",
      importedWirelessDeviceList
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.ListDevicesForWirelessDeviceImportTaskResponse
  ) extends zio.aws.iotwireless.model.ListDevicesForWirelessDeviceImportTaskResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iotwireless.model.primitives.NextToken(value))
    override val destinationName: Optional[DestinationName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationName())
        .map(value =>
          zio.aws.iotwireless.model.primitives.DestinationName(value)
        )
    override val importedWirelessDeviceList: Optional[
      List[zio.aws.iotwireless.model.ImportedWirelessDevice.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.importedWirelessDeviceList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotwireless.model.ImportedWirelessDevice.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.ListDevicesForWirelessDeviceImportTaskResponse
  ): zio.aws.iotwireless.model.ListDevicesForWirelessDeviceImportTaskResponse.ReadOnly =
    new Wrapper(impl)
}
