package zio.aws.iotwireless.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iotwireless.model.primitives.{
  NextToken,
  MaxResults,
  ImportTaskId
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListDevicesForWirelessDeviceImportTaskRequest(
    id: ImportTaskId,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    status: Optional[zio.aws.iotwireless.model.OnboardStatus] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.ListDevicesForWirelessDeviceImportTaskRequest = {
    import ListDevicesForWirelessDeviceImportTaskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.ListDevicesForWirelessDeviceImportTaskRequest
      .builder()
      .id(ImportTaskId.unwrap(id): java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.ListDevicesForWirelessDeviceImportTaskRequest.ReadOnly =
    zio.aws.iotwireless.model.ListDevicesForWirelessDeviceImportTaskRequest
      .wrap(buildAwsValue())
}
object ListDevicesForWirelessDeviceImportTaskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.ListDevicesForWirelessDeviceImportTaskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotwireless.model.ListDevicesForWirelessDeviceImportTaskRequest =
      zio.aws.iotwireless.model.ListDevicesForWirelessDeviceImportTaskRequest(
        id,
        maxResults.map(value => value),
        nextToken.map(value => value),
        status.map(value => value)
      )
    def id: ImportTaskId
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def status: Optional[zio.aws.iotwireless.model.OnboardStatus]
    def getId: ZIO[Any, Nothing, ImportTaskId] = ZIO.succeed(id)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getStatus: ZIO[Any, AwsError, zio.aws.iotwireless.model.OnboardStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.ListDevicesForWirelessDeviceImportTaskRequest
  ) extends zio.aws.iotwireless.model.ListDevicesForWirelessDeviceImportTaskRequest.ReadOnly {
    override val id: ImportTaskId =
      zio.aws.iotwireless.model.primitives.ImportTaskId(impl.id())
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.iotwireless.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iotwireless.model.primitives.NextToken(value))
    override val status: Optional[zio.aws.iotwireless.model.OnboardStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.iotwireless.model.OnboardStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.ListDevicesForWirelessDeviceImportTaskRequest
  ): zio.aws.iotwireless.model.ListDevicesForWirelessDeviceImportTaskRequest.ReadOnly =
    new Wrapper(impl)
}
