package zio.aws.iotwireless.model
import scala.jdk.CollectionConverters._
sealed trait ImportTaskStatus {
  def unwrap: software.amazon.awssdk.services.iotwireless.model.ImportTaskStatus
}
object ImportTaskStatus {
  def wrap(
      value: software.amazon.awssdk.services.iotwireless.model.ImportTaskStatus
  ): zio.aws.iotwireless.model.ImportTaskStatus = value match {
    case software.amazon.awssdk.services.iotwireless.model.ImportTaskStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotwireless.model.ImportTaskStatus.INITIALIZING =>
      val r = INITIALIZING
      r
    case software.amazon.awssdk.services.iotwireless.model.ImportTaskStatus.INITIALIZED =>
      val r = INITIALIZED
      r
    case software.amazon.awssdk.services.iotwireless.model.ImportTaskStatus.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.iotwireless.model.ImportTaskStatus.COMPLETE =>
      val r = COMPLETE
      r
    case software.amazon.awssdk.services.iotwireless.model.ImportTaskStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.iotwireless.model.ImportTaskStatus.DELETING =>
      val r = DELETING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iotwireless.model.ImportTaskStatus {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.ImportTaskStatus =
      software.amazon.awssdk.services.iotwireless.model.ImportTaskStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object INITIALIZING extends zio.aws.iotwireless.model.ImportTaskStatus {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.ImportTaskStatus =
      software.amazon.awssdk.services.iotwireless.model.ImportTaskStatus.INITIALIZING
  }
  case object INITIALIZED extends zio.aws.iotwireless.model.ImportTaskStatus {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.ImportTaskStatus =
      software.amazon.awssdk.services.iotwireless.model.ImportTaskStatus.INITIALIZED
  }
  case object PENDING extends zio.aws.iotwireless.model.ImportTaskStatus {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.ImportTaskStatus =
      software.amazon.awssdk.services.iotwireless.model.ImportTaskStatus.PENDING
  }
  case object COMPLETE extends zio.aws.iotwireless.model.ImportTaskStatus {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.ImportTaskStatus =
      software.amazon.awssdk.services.iotwireless.model.ImportTaskStatus.COMPLETE
  }
  case object FAILED extends zio.aws.iotwireless.model.ImportTaskStatus {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.ImportTaskStatus =
      software.amazon.awssdk.services.iotwireless.model.ImportTaskStatus.FAILED
  }
  case object DELETING extends zio.aws.iotwireless.model.ImportTaskStatus {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.ImportTaskStatus =
      software.amazon.awssdk.services.iotwireless.model.ImportTaskStatus.DELETING
  }
}
