package zio.aws.iotwireless.model
import java.lang.Integer
import zio.aws.iotwireless.model.primitives.{GeranCid, LAC}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GlobalIdentity(lac: LAC, geranCid: GeranCid) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.GlobalIdentity = {
    import GlobalIdentity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.GlobalIdentity
      .builder()
      .lac(LAC.unwrap(lac): Integer)
      .geranCid(GeranCid.unwrap(geranCid): Integer)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.GlobalIdentity.ReadOnly =
    zio.aws.iotwireless.model.GlobalIdentity.wrap(buildAwsValue())
}
object GlobalIdentity {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.GlobalIdentity
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.GlobalIdentity =
      zio.aws.iotwireless.model.GlobalIdentity(lac, geranCid)
    def lac: LAC
    def geranCid: GeranCid
    def getLac: ZIO[Any, Nothing, LAC] = ZIO.succeed(lac)
    def getGeranCid: ZIO[Any, Nothing, GeranCid] = ZIO.succeed(geranCid)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.GlobalIdentity
  ) extends zio.aws.iotwireless.model.GlobalIdentity.ReadOnly {
    override val lac: LAC = zio.aws.iotwireless.model.primitives.LAC(impl.lac())
    override val geranCid: GeranCid =
      zio.aws.iotwireless.model.primitives.GeranCid(impl.geranCid())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.GlobalIdentity
  ): zio.aws.iotwireless.model.GlobalIdentity.ReadOnly = new Wrapper(impl)
}
