package zio.aws.iotwireless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetResourceEventConfigurationResponse(
    deviceRegistrationState: Optional[
      zio.aws.iotwireless.model.DeviceRegistrationStateEventConfiguration
    ] = Optional.Absent,
    proximity: Optional[zio.aws.iotwireless.model.ProximityEventConfiguration] =
      Optional.Absent,
    join: Optional[zio.aws.iotwireless.model.JoinEventConfiguration] =
      Optional.Absent,
    connectionStatus: Optional[
      zio.aws.iotwireless.model.ConnectionStatusEventConfiguration
    ] = Optional.Absent,
    messageDeliveryStatus: Optional[
      zio.aws.iotwireless.model.MessageDeliveryStatusEventConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.GetResourceEventConfigurationResponse = {
    import GetResourceEventConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.GetResourceEventConfigurationResponse
      .builder()
      .optionallyWith(
        deviceRegistrationState.map(value => value.buildAwsValue())
      )(_.deviceRegistrationState)
      .optionallyWith(proximity.map(value => value.buildAwsValue()))(
        _.proximity
      )
      .optionallyWith(join.map(value => value.buildAwsValue()))(_.join)
      .optionallyWith(connectionStatus.map(value => value.buildAwsValue()))(
        _.connectionStatus
      )
      .optionallyWith(
        messageDeliveryStatus.map(value => value.buildAwsValue())
      )(_.messageDeliveryStatus)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.GetResourceEventConfigurationResponse.ReadOnly =
    zio.aws.iotwireless.model.GetResourceEventConfigurationResponse
      .wrap(buildAwsValue())
}
object GetResourceEventConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.GetResourceEventConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotwireless.model.GetResourceEventConfigurationResponse =
      zio.aws.iotwireless.model.GetResourceEventConfigurationResponse(
        deviceRegistrationState.map(value => value.asEditable),
        proximity.map(value => value.asEditable),
        join.map(value => value.asEditable),
        connectionStatus.map(value => value.asEditable),
        messageDeliveryStatus.map(value => value.asEditable)
      )
    def deviceRegistrationState: Optional[
      zio.aws.iotwireless.model.DeviceRegistrationStateEventConfiguration.ReadOnly
    ]
    def proximity: Optional[
      zio.aws.iotwireless.model.ProximityEventConfiguration.ReadOnly
    ]
    def join
        : Optional[zio.aws.iotwireless.model.JoinEventConfiguration.ReadOnly]
    def connectionStatus: Optional[
      zio.aws.iotwireless.model.ConnectionStatusEventConfiguration.ReadOnly
    ]
    def messageDeliveryStatus: Optional[
      zio.aws.iotwireless.model.MessageDeliveryStatusEventConfiguration.ReadOnly
    ]
    def getDeviceRegistrationState: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.DeviceRegistrationStateEventConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "deviceRegistrationState",
      deviceRegistrationState
    )
    def getProximity: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.ProximityEventConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("proximity", proximity)
    def getJoin: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.JoinEventConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("join", join)
    def getConnectionStatus: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.ConnectionStatusEventConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("connectionStatus", connectionStatus)
    def getMessageDeliveryStatus: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.MessageDeliveryStatusEventConfiguration.ReadOnly
    ] =
      AwsError.unwrapOptionField("messageDeliveryStatus", messageDeliveryStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.GetResourceEventConfigurationResponse
  ) extends zio.aws.iotwireless.model.GetResourceEventConfigurationResponse.ReadOnly {
    override val deviceRegistrationState: Optional[
      zio.aws.iotwireless.model.DeviceRegistrationStateEventConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.deviceRegistrationState())
      .map(value =>
        zio.aws.iotwireless.model.DeviceRegistrationStateEventConfiguration
          .wrap(value)
      )
    override val proximity: Optional[
      zio.aws.iotwireless.model.ProximityEventConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.proximity())
      .map(value =>
        zio.aws.iotwireless.model.ProximityEventConfiguration.wrap(value)
      )
    override val join
        : Optional[zio.aws.iotwireless.model.JoinEventConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.join())
        .map(value =>
          zio.aws.iotwireless.model.JoinEventConfiguration.wrap(value)
        )
    override val connectionStatus: Optional[
      zio.aws.iotwireless.model.ConnectionStatusEventConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.connectionStatus())
      .map(value =>
        zio.aws.iotwireless.model.ConnectionStatusEventConfiguration.wrap(value)
      )
    override val messageDeliveryStatus: Optional[
      zio.aws.iotwireless.model.MessageDeliveryStatusEventConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.messageDeliveryStatus())
      .map(value =>
        zio.aws.iotwireless.model.MessageDeliveryStatusEventConfiguration
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.GetResourceEventConfigurationResponse
  ): zio.aws.iotwireless.model.GetResourceEventConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
