package zio.aws.iotwireless.model
import scala.jdk.CollectionConverters._
sealed trait DownlinkMode {
  def unwrap: software.amazon.awssdk.services.iotwireless.model.DownlinkMode
}
object DownlinkMode {
  def wrap(
      value: software.amazon.awssdk.services.iotwireless.model.DownlinkMode
  ): zio.aws.iotwireless.model.DownlinkMode = value match {
    case software.amazon.awssdk.services.iotwireless.model.DownlinkMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotwireless.model.DownlinkMode.SEQUENTIAL =>
      val r = SEQUENTIAL
      r
    case software.amazon.awssdk.services.iotwireless.model.DownlinkMode.CONCURRENT =>
      val r = CONCURRENT
      r
    case software.amazon.awssdk.services.iotwireless.model.DownlinkMode.USING_UPLINK_GATEWAY =>
      val r = USING_UPLINK_GATEWAY
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iotwireless.model.DownlinkMode {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.DownlinkMode =
      software.amazon.awssdk.services.iotwireless.model.DownlinkMode.UNKNOWN_TO_SDK_VERSION
  }
  case object SEQUENTIAL extends zio.aws.iotwireless.model.DownlinkMode {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.DownlinkMode =
      software.amazon.awssdk.services.iotwireless.model.DownlinkMode.SEQUENTIAL
  }
  case object CONCURRENT extends zio.aws.iotwireless.model.DownlinkMode {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.DownlinkMode =
      software.amazon.awssdk.services.iotwireless.model.DownlinkMode.CONCURRENT
  }
  case object USING_UPLINK_GATEWAY
      extends zio.aws.iotwireless.model.DownlinkMode {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.DownlinkMode =
      software.amazon.awssdk.services.iotwireless.model.DownlinkMode.USING_UPLINK_GATEWAY
  }
}
