package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.WirelessDeviceId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DisassociateWirelessDeviceFromThingRequest(
    id: WirelessDeviceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.DisassociateWirelessDeviceFromThingRequest = {
    import DisassociateWirelessDeviceFromThingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.DisassociateWirelessDeviceFromThingRequest
      .builder()
      .id(WirelessDeviceId.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.DisassociateWirelessDeviceFromThingRequest.ReadOnly =
    zio.aws.iotwireless.model.DisassociateWirelessDeviceFromThingRequest
      .wrap(buildAwsValue())
}
object DisassociateWirelessDeviceFromThingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.DisassociateWirelessDeviceFromThingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotwireless.model.DisassociateWirelessDeviceFromThingRequest =
      zio.aws.iotwireless.model.DisassociateWirelessDeviceFromThingRequest(id)
    def id: WirelessDeviceId
    def getId: ZIO[Any, Nothing, WirelessDeviceId] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.DisassociateWirelessDeviceFromThingRequest
  ) extends zio.aws.iotwireless.model.DisassociateWirelessDeviceFromThingRequest.ReadOnly {
    override val id: WirelessDeviceId =
      zio.aws.iotwireless.model.primitives.WirelessDeviceId(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.DisassociateWirelessDeviceFromThingRequest
  ): zio.aws.iotwireless.model.DisassociateWirelessDeviceFromThingRequest.ReadOnly =
    new Wrapper(impl)
}
