package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{
  WirelessGatewayTaskDefinitionId,
  WirelessGatewayId
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateWirelessGatewayTaskRequest(
    id: WirelessGatewayId,
    wirelessGatewayTaskDefinitionId: WirelessGatewayTaskDefinitionId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.CreateWirelessGatewayTaskRequest = {
    import CreateWirelessGatewayTaskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.CreateWirelessGatewayTaskRequest
      .builder()
      .id(WirelessGatewayId.unwrap(id): java.lang.String)
      .wirelessGatewayTaskDefinitionId(
        WirelessGatewayTaskDefinitionId.unwrap(
          wirelessGatewayTaskDefinitionId
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.CreateWirelessGatewayTaskRequest.ReadOnly =
    zio.aws.iotwireless.model.CreateWirelessGatewayTaskRequest
      .wrap(buildAwsValue())
}
object CreateWirelessGatewayTaskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.CreateWirelessGatewayTaskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.CreateWirelessGatewayTaskRequest =
      zio.aws.iotwireless.model
        .CreateWirelessGatewayTaskRequest(id, wirelessGatewayTaskDefinitionId)
    def id: WirelessGatewayId
    def wirelessGatewayTaskDefinitionId: WirelessGatewayTaskDefinitionId
    def getId: ZIO[Any, Nothing, WirelessGatewayId] = ZIO.succeed(id)
    def getWirelessGatewayTaskDefinitionId
        : ZIO[Any, Nothing, WirelessGatewayTaskDefinitionId] =
      ZIO.succeed(wirelessGatewayTaskDefinitionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.CreateWirelessGatewayTaskRequest
  ) extends zio.aws.iotwireless.model.CreateWirelessGatewayTaskRequest.ReadOnly {
    override val id: WirelessGatewayId =
      zio.aws.iotwireless.model.primitives.WirelessGatewayId(impl.id())
    override val wirelessGatewayTaskDefinitionId
        : WirelessGatewayTaskDefinitionId = zio.aws.iotwireless.model.primitives
      .WirelessGatewayTaskDefinitionId(impl.wirelessGatewayTaskDefinitionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.CreateWirelessGatewayTaskRequest
  ): zio.aws.iotwireless.model.CreateWirelessGatewayTaskRequest.ReadOnly =
    new Wrapper(impl)
}
