package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{
  WirelessGatewayTaskDefinitionArn,
  WirelessGatewayTaskDefinitionId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateWirelessGatewayTaskDefinitionResponse(
    id: Optional[WirelessGatewayTaskDefinitionId] = Optional.Absent,
    arn: Optional[WirelessGatewayTaskDefinitionArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.CreateWirelessGatewayTaskDefinitionResponse = {
    import CreateWirelessGatewayTaskDefinitionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.CreateWirelessGatewayTaskDefinitionResponse
      .builder()
      .optionallyWith(
        id.map(value =>
          WirelessGatewayTaskDefinitionId.unwrap(value): java.lang.String
        )
      )(_.id)
      .optionallyWith(
        arn.map(value =>
          WirelessGatewayTaskDefinitionArn.unwrap(value): java.lang.String
        )
      )(_.arn)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.CreateWirelessGatewayTaskDefinitionResponse.ReadOnly =
    zio.aws.iotwireless.model.CreateWirelessGatewayTaskDefinitionResponse
      .wrap(buildAwsValue())
}
object CreateWirelessGatewayTaskDefinitionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.CreateWirelessGatewayTaskDefinitionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotwireless.model.CreateWirelessGatewayTaskDefinitionResponse =
      zio.aws.iotwireless.model.CreateWirelessGatewayTaskDefinitionResponse(
        id.map(value => value),
        arn.map(value => value)
      )
    def id: Optional[WirelessGatewayTaskDefinitionId]
    def arn: Optional[WirelessGatewayTaskDefinitionArn]
    def getId: ZIO[Any, AwsError, WirelessGatewayTaskDefinitionId] =
      AwsError.unwrapOptionField("id", id)
    def getArn: ZIO[Any, AwsError, WirelessGatewayTaskDefinitionArn] =
      AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.CreateWirelessGatewayTaskDefinitionResponse
  ) extends zio.aws.iotwireless.model.CreateWirelessGatewayTaskDefinitionResponse.ReadOnly {
    override val id: Optional[WirelessGatewayTaskDefinitionId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.id())
        .map(value =>
          zio.aws.iotwireless.model.primitives
            .WirelessGatewayTaskDefinitionId(value)
        )
    override val arn: Optional[WirelessGatewayTaskDefinitionArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.arn())
        .map(value =>
          zio.aws.iotwireless.model.primitives
            .WirelessGatewayTaskDefinitionArn(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.CreateWirelessGatewayTaskDefinitionResponse
  ): zio.aws.iotwireless.model.CreateWirelessGatewayTaskDefinitionResponse.ReadOnly =
    new Wrapper(impl)
}
