package zio.aws.iotwireless.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iotwireless.model.primitives.{
  FragmentIntervalMS,
  FirmwareUpdateRole,
  FragmentSizeBytes,
  ClientRequestToken,
  FirmwareUpdateImage,
  FuotaTaskName,
  Description,
  RedundancyPercent
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class CreateFuotaTaskRequest(
    name: Optional[FuotaTaskName] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    clientRequestToken: Optional[ClientRequestToken] = Optional.Absent,
    loRaWAN: Optional[zio.aws.iotwireless.model.LoRaWANFuotaTask] =
      Optional.Absent,
    firmwareUpdateImage: FirmwareUpdateImage,
    firmwareUpdateRole: FirmwareUpdateRole,
    tags: Optional[Iterable[zio.aws.iotwireless.model.Tag]] = Optional.Absent,
    redundancyPercent: Optional[RedundancyPercent] = Optional.Absent,
    fragmentSizeBytes: Optional[FragmentSizeBytes] = Optional.Absent,
    fragmentIntervalMS: Optional[FragmentIntervalMS] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.CreateFuotaTaskRequest = {
    import CreateFuotaTaskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.CreateFuotaTaskRequest
      .builder()
      .optionallyWith(
        name.map(value => FuotaTaskName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .optionallyWith(loRaWAN.map(value => value.buildAwsValue()))(_.loRaWAN)
      .firmwareUpdateImage(
        FirmwareUpdateImage.unwrap(firmwareUpdateImage): java.lang.String
      )
      .firmwareUpdateRole(
        FirmwareUpdateRole.unwrap(firmwareUpdateRole): java.lang.String
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        redundancyPercent.map(value => RedundancyPercent.unwrap(value): Integer)
      )(_.redundancyPercent)
      .optionallyWith(
        fragmentSizeBytes.map(value => FragmentSizeBytes.unwrap(value): Integer)
      )(_.fragmentSizeBytes)
      .optionallyWith(
        fragmentIntervalMS.map(value =>
          FragmentIntervalMS.unwrap(value): Integer
        )
      )(_.fragmentIntervalMS)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.CreateFuotaTaskRequest.ReadOnly =
    zio.aws.iotwireless.model.CreateFuotaTaskRequest.wrap(buildAwsValue())
}
object CreateFuotaTaskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.CreateFuotaTaskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.CreateFuotaTaskRequest =
      zio.aws.iotwireless.model.CreateFuotaTaskRequest(
        name.map(value => value),
        description.map(value => value),
        clientRequestToken.map(value => value),
        loRaWAN.map(value => value.asEditable),
        firmwareUpdateImage,
        firmwareUpdateRole,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        redundancyPercent.map(value => value),
        fragmentSizeBytes.map(value => value),
        fragmentIntervalMS.map(value => value)
      )
    def name: Optional[FuotaTaskName]
    def description: Optional[Description]
    def clientRequestToken: Optional[ClientRequestToken]
    def loRaWAN: Optional[zio.aws.iotwireless.model.LoRaWANFuotaTask.ReadOnly]
    def firmwareUpdateImage: FirmwareUpdateImage
    def firmwareUpdateRole: FirmwareUpdateRole
    def tags: Optional[List[zio.aws.iotwireless.model.Tag.ReadOnly]]
    def redundancyPercent: Optional[RedundancyPercent]
    def fragmentSizeBytes: Optional[FragmentSizeBytes]
    def fragmentIntervalMS: Optional[FragmentIntervalMS]
    def getName: ZIO[Any, AwsError, FuotaTaskName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getLoRaWAN: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.LoRaWANFuotaTask.ReadOnly
    ] = AwsError.unwrapOptionField("loRaWAN", loRaWAN)
    def getFirmwareUpdateImage: ZIO[Any, Nothing, FirmwareUpdateImage] =
      ZIO.succeed(firmwareUpdateImage)
    def getFirmwareUpdateRole: ZIO[Any, Nothing, FirmwareUpdateRole] =
      ZIO.succeed(firmwareUpdateRole)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.iotwireless.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getRedundancyPercent: ZIO[Any, AwsError, RedundancyPercent] =
      AwsError.unwrapOptionField("redundancyPercent", redundancyPercent)
    def getFragmentSizeBytes: ZIO[Any, AwsError, FragmentSizeBytes] =
      AwsError.unwrapOptionField("fragmentSizeBytes", fragmentSizeBytes)
    def getFragmentIntervalMS: ZIO[Any, AwsError, FragmentIntervalMS] =
      AwsError.unwrapOptionField("fragmentIntervalMS", fragmentIntervalMS)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.CreateFuotaTaskRequest
  ) extends zio.aws.iotwireless.model.CreateFuotaTaskRequest.ReadOnly {
    override val name: Optional[FuotaTaskName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.iotwireless.model.primitives.FuotaTaskName(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.iotwireless.model.primitives.Description(value))
    override val clientRequestToken: Optional[ClientRequestToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value =>
          zio.aws.iotwireless.model.primitives.ClientRequestToken(value)
        )
    override val loRaWAN
        : Optional[zio.aws.iotwireless.model.LoRaWANFuotaTask.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.loRaWAN())
        .map(value => zio.aws.iotwireless.model.LoRaWANFuotaTask.wrap(value))
    override val firmwareUpdateImage: FirmwareUpdateImage =
      zio.aws.iotwireless.model.primitives
        .FirmwareUpdateImage(impl.firmwareUpdateImage())
    override val firmwareUpdateRole: FirmwareUpdateRole =
      zio.aws.iotwireless.model.primitives
        .FirmwareUpdateRole(impl.firmwareUpdateRole())
    override val tags: Optional[List[zio.aws.iotwireless.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotwireless.model.Tag.wrap(item)
          }.toList
        )
    override val redundancyPercent: Optional[RedundancyPercent] =
      zio.aws.core.internal
        .optionalFromNullable(impl.redundancyPercent())
        .map(value =>
          zio.aws.iotwireless.model.primitives.RedundancyPercent(value)
        )
    override val fragmentSizeBytes: Optional[FragmentSizeBytes] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fragmentSizeBytes())
        .map(value =>
          zio.aws.iotwireless.model.primitives.FragmentSizeBytes(value)
        )
    override val fragmentIntervalMS: Optional[FragmentIntervalMS] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fragmentIntervalMS())
        .map(value =>
          zio.aws.iotwireless.model.primitives.FragmentIntervalMS(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.CreateFuotaTaskRequest
  ): zio.aws.iotwireless.model.CreateFuotaTaskRequest.ReadOnly = new Wrapper(
    impl
  )
}
