package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{
  RoleArn,
  ClientRequestToken,
  Expression,
  Description,
  DestinationName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateDestinationRequest(
    name: DestinationName,
    expressionType: zio.aws.iotwireless.model.ExpressionType,
    expression: Expression,
    description: Optional[Description] = Optional.Absent,
    roleArn: RoleArn,
    tags: Optional[Iterable[zio.aws.iotwireless.model.Tag]] = Optional.Absent,
    clientRequestToken: Optional[ClientRequestToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.CreateDestinationRequest = {
    import CreateDestinationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.CreateDestinationRequest
      .builder()
      .name(DestinationName.unwrap(name): java.lang.String)
      .expressionType(expressionType.unwrap)
      .expression(Expression.unwrap(expression): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .roleArn(RoleArn.unwrap(roleArn): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.CreateDestinationRequest.ReadOnly =
    zio.aws.iotwireless.model.CreateDestinationRequest.wrap(buildAwsValue())
}
object CreateDestinationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.CreateDestinationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.CreateDestinationRequest =
      zio.aws.iotwireless.model.CreateDestinationRequest(
        name,
        expressionType,
        expression,
        description.map(value => value),
        roleArn,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        clientRequestToken.map(value => value)
      )
    def name: DestinationName
    def expressionType: zio.aws.iotwireless.model.ExpressionType
    def expression: Expression
    def description: Optional[Description]
    def roleArn: RoleArn
    def tags: Optional[List[zio.aws.iotwireless.model.Tag.ReadOnly]]
    def clientRequestToken: Optional[ClientRequestToken]
    def getName: ZIO[Any, Nothing, DestinationName] = ZIO.succeed(name)
    def getExpressionType
        : ZIO[Any, Nothing, zio.aws.iotwireless.model.ExpressionType] =
      ZIO.succeed(expressionType)
    def getExpression: ZIO[Any, Nothing, Expression] = ZIO.succeed(expression)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(roleArn)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.iotwireless.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.CreateDestinationRequest
  ) extends zio.aws.iotwireless.model.CreateDestinationRequest.ReadOnly {
    override val name: DestinationName =
      zio.aws.iotwireless.model.primitives.DestinationName(impl.name())
    override val expressionType: zio.aws.iotwireless.model.ExpressionType =
      zio.aws.iotwireless.model.ExpressionType.wrap(impl.expressionType())
    override val expression: Expression =
      zio.aws.iotwireless.model.primitives.Expression(impl.expression())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.iotwireless.model.primitives.Description(value))
    override val roleArn: RoleArn =
      zio.aws.iotwireless.model.primitives.RoleArn(impl.roleArn())
    override val tags: Optional[List[zio.aws.iotwireless.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotwireless.model.Tag.wrap(item)
          }.toList
        )
    override val clientRequestToken: Optional[ClientRequestToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value =>
          zio.aws.iotwireless.model.primitives.ClientRequestToken(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.CreateDestinationRequest
  ): zio.aws.iotwireless.model.CreateDestinationRequest.ReadOnly = new Wrapper(
    impl
  )
}
