package zio.aws.iotwireless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ConnectionStatusEventConfiguration(
    loRaWAN: Optional[
      zio.aws.iotwireless.model.LoRaWANConnectionStatusEventNotificationConfigurations
    ] = Optional.Absent,
    wirelessGatewayIdEventTopic: Optional[
      zio.aws.iotwireless.model.EventNotificationTopicStatus
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.ConnectionStatusEventConfiguration = {
    import ConnectionStatusEventConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.ConnectionStatusEventConfiguration
      .builder()
      .optionallyWith(loRaWAN.map(value => value.buildAwsValue()))(_.loRaWAN)
      .optionallyWith(wirelessGatewayIdEventTopic.map(value => value.unwrap))(
        _.wirelessGatewayIdEventTopic
      )
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.ConnectionStatusEventConfiguration.ReadOnly =
    zio.aws.iotwireless.model.ConnectionStatusEventConfiguration
      .wrap(buildAwsValue())
}
object ConnectionStatusEventConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.ConnectionStatusEventConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotwireless.model.ConnectionStatusEventConfiguration =
      zio.aws.iotwireless.model.ConnectionStatusEventConfiguration(
        loRaWAN.map(value => value.asEditable),
        wirelessGatewayIdEventTopic.map(value => value)
      )
    def loRaWAN: Optional[
      zio.aws.iotwireless.model.LoRaWANConnectionStatusEventNotificationConfigurations.ReadOnly
    ]
    def wirelessGatewayIdEventTopic
        : Optional[zio.aws.iotwireless.model.EventNotificationTopicStatus]
    def getLoRaWAN: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.LoRaWANConnectionStatusEventNotificationConfigurations.ReadOnly
    ] = AwsError.unwrapOptionField("loRaWAN", loRaWAN)
    def getWirelessGatewayIdEventTopic: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.EventNotificationTopicStatus
    ] = AwsError.unwrapOptionField(
      "wirelessGatewayIdEventTopic",
      wirelessGatewayIdEventTopic
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.ConnectionStatusEventConfiguration
  ) extends zio.aws.iotwireless.model.ConnectionStatusEventConfiguration.ReadOnly {
    override val loRaWAN: Optional[
      zio.aws.iotwireless.model.LoRaWANConnectionStatusEventNotificationConfigurations.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.loRaWAN())
      .map(value =>
        zio.aws.iotwireless.model.LoRaWANConnectionStatusEventNotificationConfigurations
          .wrap(value)
      )
    override val wirelessGatewayIdEventTopic
        : Optional[zio.aws.iotwireless.model.EventNotificationTopicStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.wirelessGatewayIdEventTopic())
        .map(value =>
          zio.aws.iotwireless.model.EventNotificationTopicStatus.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.ConnectionStatusEventConfiguration
  ): zio.aws.iotwireless.model.ConnectionStatusEventConfiguration.ReadOnly =
    new Wrapper(impl)
}
