package zio.aws.iotwireless.model
import java.lang.Integer
import zio.aws.iotwireless.model.primitives.{CdmaChannel, PnOffset}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CdmaLocalId(pnOffset: PnOffset, cdmaChannel: CdmaChannel) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.CdmaLocalId = {
    import CdmaLocalId.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.CdmaLocalId
      .builder()
      .pnOffset(PnOffset.unwrap(pnOffset): Integer)
      .cdmaChannel(CdmaChannel.unwrap(cdmaChannel): Integer)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.CdmaLocalId.ReadOnly =
    zio.aws.iotwireless.model.CdmaLocalId.wrap(buildAwsValue())
}
object CdmaLocalId {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.CdmaLocalId
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.CdmaLocalId =
      zio.aws.iotwireless.model.CdmaLocalId(pnOffset, cdmaChannel)
    def pnOffset: PnOffset
    def cdmaChannel: CdmaChannel
    def getPnOffset: ZIO[Any, Nothing, PnOffset] = ZIO.succeed(pnOffset)
    def getCdmaChannel: ZIO[Any, Nothing, CdmaChannel] =
      ZIO.succeed(cdmaChannel)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.CdmaLocalId
  ) extends zio.aws.iotwireless.model.CdmaLocalId.ReadOnly {
    override val pnOffset: PnOffset =
      zio.aws.iotwireless.model.primitives.PnOffset(impl.pnOffset())
    override val cdmaChannel: CdmaChannel =
      zio.aws.iotwireless.model.primitives.CdmaChannel(impl.cdmaChannel())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.CdmaLocalId
  ): zio.aws.iotwireless.model.CdmaLocalId.ReadOnly = new Wrapper(impl)
}
