package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{MulticastGroupId, FuotaTaskId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AssociateMulticastGroupWithFuotaTaskRequest(
    id: FuotaTaskId,
    multicastGroupId: MulticastGroupId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.AssociateMulticastGroupWithFuotaTaskRequest = {
    import AssociateMulticastGroupWithFuotaTaskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.AssociateMulticastGroupWithFuotaTaskRequest
      .builder()
      .id(FuotaTaskId.unwrap(id): java.lang.String)
      .multicastGroupId(
        MulticastGroupId.unwrap(multicastGroupId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.AssociateMulticastGroupWithFuotaTaskRequest.ReadOnly =
    zio.aws.iotwireless.model.AssociateMulticastGroupWithFuotaTaskRequest
      .wrap(buildAwsValue())
}
object AssociateMulticastGroupWithFuotaTaskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.AssociateMulticastGroupWithFuotaTaskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotwireless.model.AssociateMulticastGroupWithFuotaTaskRequest =
      zio.aws.iotwireless.model
        .AssociateMulticastGroupWithFuotaTaskRequest(id, multicastGroupId)
    def id: FuotaTaskId
    def multicastGroupId: MulticastGroupId
    def getId: ZIO[Any, Nothing, FuotaTaskId] = ZIO.succeed(id)
    def getMulticastGroupId: ZIO[Any, Nothing, MulticastGroupId] =
      ZIO.succeed(multicastGroupId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.AssociateMulticastGroupWithFuotaTaskRequest
  ) extends zio.aws.iotwireless.model.AssociateMulticastGroupWithFuotaTaskRequest.ReadOnly {
    override val id: FuotaTaskId =
      zio.aws.iotwireless.model.primitives.FuotaTaskId(impl.id())
    override val multicastGroupId: MulticastGroupId =
      zio.aws.iotwireless.model.primitives
        .MulticastGroupId(impl.multicastGroupId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.AssociateMulticastGroupWithFuotaTaskRequest
  ): zio.aws.iotwireless.model.AssociateMulticastGroupWithFuotaTaskRequest.ReadOnly =
    new Wrapper(impl)
}
